<?php
namespace Expedux\PushAlert\Controller\Alert;
class Save extends \Magento\Framework\App\Action\Action
{

	
        /**
         * @var \Magento\Framework\View\Result\PageFactory
         */
        protected $resultPageFactory;
        /**
         * @param \Magento\Framework\App\Action\Context $context
         * @param \Magento\Framework\View\Result\PageFactory resultPageFactory
         */
        public function __construct(
            \Magento\Framework\App\Action\Context $context,
            \Magento\Customer\Model\Customer $customer,
            \Magento\Customer\Model\ResourceModel\CustomerFactory $customerFactory,
            \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
            \Magento\Framework\View\Result\PageFactory $resultPageFactory
        )
        {
            $this->resultPageFactory = $resultPageFactory;
            $this->_orderCollectionFactory = $orderCollectionFactory;
            $this->customer = $customer;
            $this->customerFactory = $customerFactory;
            parent::__construct($context);
        }
    /**
     * Default customer account page
     *
     * @return void
     */
    public function execute()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
        $urlInterface = $objectManager->get('\Magento\Framework\UrlInterface');

        if(!$customerSession->isLoggedIn()) {
            $customerSession->setAfterAuthUrl($urlInterface->getCurrentUrl());
            $customerSession->authenticate();
        } else {
            $customer_email = $customerSession->getCustomer()->getEmail();
            $customerId = $customerSession->getCustomer()->getId();
            $post = $this->getRequest()->getPost();
            $customerId = $post['customer_id'];
			$subscriberId = $post['subscriber_id'];
               $customer = $this->customer->load($customerId);
                $customerData = $customer->getDataModel();
                $customerData->setCustomAttribute('pushalert_subs_id',$subscriberId);
                $customer->updateData($customerData);
                $customerResource = $this->customerFactory->create();
                $customerResource->saveAttribute($customer, 'pushalert_subs_id');
            return $this->resultPageFactory->create();
        }
    }
}
?>