<?php
namespace Expedux\PushAlert\Controller\Alert;
class Index extends \Magento\Framework\App\Action\Action
{

	
        /**
         * @var \Magento\Framework\View\Result\PageFactory
         */
        protected $resultPageFactory;
        /**
         * @param \Magento\Framework\App\Action\Context $context
         * @param \Magento\Framework\View\Result\PageFactory resultPageFactory
         */
        public function __construct(
            \Magento\Framework\App\Action\Context $context,
            \Magento\Customer\Model\Customer $customer,
            \Magento\Customer\Model\ResourceModel\CustomerFactory $customerFactory,
            \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $orderCollectionFactory,
            \Magento\Framework\View\Result\PageFactory $resultPageFactory
        )
        {
            $this->resultPageFactory = $resultPageFactory;
            $this->_orderCollectionFactory = $orderCollectionFactory;
            $this->customer = $customer;
            $this->customerFactory = $customerFactory;
            parent::__construct($context);
        }
    /**
     * Default customer account page
     *
     * @return void
     */
    public function execute()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
        $urlInterface = $objectManager->get('\Magento\Framework\UrlInterface');

        if(!$customerSession->isLoggedIn()) {
            $customerSession->setAfterAuthUrl($urlInterface->getCurrentUrl());
            $customerSession->authenticate();
        } else {
            $customer_email = $customerSession->getCustomer()->getEmail();
            $customerId = $customerSession->getCustomer()->getId();
            $order_collection = $this->_orderCollectionFactory->create()->addAttributeToFilter('customer_email', $customer_email);
            $orderIds = array();   
            $skus = array(); 
            $cities =  array();
            foreach ($order_collection as $order)
               {
                   $orderIds[] = $order->getEntityId();
                   $shippingAddress = $order->getShippingAddress();
                   $city = strtolower($shippingAddress->getCity());
			       if(strlen($city) > 64) $city = substr($city,0,64);
                   $cities [] = $city;
                   $items = $order->getAllItems();
                  
                   foreach ($items as $itemId => $item){
                    $sku = $item->getSku();
                    if(!empty($sku))
                    {
                    $sku = str_replace('/','-',strtolower($sku));
                    $sku = preg_replace('/[^a-zA-Z0-9-]/','-', $sku);
                    if(strlen($sku) > 64) $sku = substr($sku,0,64);

                    $skus[] = $sku;

                    }
                   }
               } 
               $skus = array_unique($skus);
               $cities = array_unique($cities);
               $cities_str = implode(',',$cities);
               if(strlen($cities_str) > 64) $cities_str = substr($cities_str,0,64);
               $skus_str = '';
               if(count($skus) > 0)
               {
                   foreach($skus as $sk)
                   {
                       $skus_str .= '"'.$sk.'":"1",';
                   }
               }
               //echo "dsfdsf";exit;
            return $this->resultPageFactory->create();
        }
    }
}
?>