<?php
namespace Expedux\PushAlert\Setup;

use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Eav\Model\Config;
use Magento\Customer\Model\Customer;

class UpgradeData implements UpgradeDataInterface
{
    private $customerSetupFactory;

    public function __construct(
        \Magento\Customer\Setup\CustomerSetupFactory $customerSetupFactory,
        Config $eavConfig
        )
    {
        $this->customerSetupFactory = $customerSetupFactory;
        $this->eavConfig       = $eavConfig;
    }

    public function upgrade(ModuleDataSetupInterface
         $setup, ModuleContextInterface $context) {
        /** @var CustomerSetup $customerSetup */

        $setup->startSetup();

        /** @var CustomerSetup $customerSetup */
        $customerSetup = $this->customerSetupFactory->create(['setup' => $setup]);

        $customerEntity = $customerSetup->getEavConfig()->getEntityType('customer');
        $attributeSetId = $customerEntity->getDefaultAttributeSetId();
        

        if (version_compare($context->getVersion(), '1.0.3') < 0) {
                    $customerSetup->addAttribute(\Magento\Customer\Model\Customer::ENTITY, 'pushalert_subs_id', [
                        'type' => 'varchar',
                        'label' => 'PushAlert Id',
                        'input' => 'text',
                        'source' => '',
                        'required' => false,
                        'visible' => true,
                        'position' => 999,
                        'system' => false,
                        'backend' => ''
                    ]);
                    $attribute = $customerSetup->getEavConfig()->getAttribute(\Magento\Customer\Model\Customer::ENTITY, 'pushalert_subs_id')
                ->addData(['used_in_forms' => [
                    'adminhtml_customer',
                    'adminhtml_checkout',
                    'customer_account_create',
                    'customer_account_edit'
                ]]);
            $attribute->save();
         }
        
        $setup->endSetup();
    }
}