<?php

use Magento\Catalog\Api\Data\ProductInterfaceFactory;
use Magento\Catalog\Model\ProductRepository;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Framework\Exception\AlreadyExistsException;

$objectManager = Bootstrap::getObjectManager();
/** @var ProductRepository $productResource */
$productResource = $objectManager->get(ProductRepository::class);
/** @var ProductInterfaceFactory $productInterfaceFactory */
$productInterfaceFactory = $objectManager->get(ProductInterfaceFactory::class);
$productInterface = $productInterfaceFactory->create();

$productInterface->setTypeId('simple')
    ->setAttributeSetId(4)
    ->setWebsiteIds([1])
    ->setName('Simple Product Saved using product repository')
    ->setSku('pos_simple_using_repository')
    ->setPrice(10)
    ->setMetaTitle('meta title')
    ->setMetaKeyword('meta keyword')
    ->setMetaDescription('meta description')
    ->setVisibility(\Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH)
    ->setStatus(\Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED)
    ->setCanSaveCustomOptions(true)
    ->setStockData(
        [
            'use_config_manage_stock'   => 1,
            'qty'                       => 100,
            'is_qty_decimal'            => 0,
            'is_in_stock'               => 1,
        ]
    );

try {
    $productInterface->setId(20042);
    $productInterface->isObjectNew(true);
    $productResource->save($productInterface);
} catch (AlreadyExistsException $e) {
    $productInterface = $productResource->getById(20042);
}
