<?php

namespace Ebizmarts\SagePaySuite\Test\Helper;

use Magento\Framework\App\Cache\Manager as CacheManager;
use Magento\Config\Model\Config as MagentoConfig;
use Ebizmarts\SagePaySuite\Model\Config as SageConfig;

class CreateOrder
{
    public const TEST_API_KEY = "snEEZ7EFaM5q9GzBspep";
    public const TEST_API_PASSWORD = "MrzrB8u3CST4FLLNRXL6";
    public const TEST_REPORTING_USERNAME = "integration_tester";
    public const TEST_REPORTING_PASSWORD = '47AEt@YEc^gfkEM2D+Ex5$sVcRbdm6gV';

    /** @var MagentoConfig $config */
    private $config;

    /** @var CacheManager $cacheManager */
    private $cacheManager;

    /**
     * @param MagentoConfig $config
     * @param CacheManager $cacheManager
     */
    public function __construct(
        MagentoConfig $config,
        CacheManager $cacheManager
    ) {
        $this->config = $config;
        $this->cacheManager = $cacheManager;
    }

    /**
     * @return void
     * @throws \Exception
     */
    public function saveConfig($mode)
    {
        $this->saveCoreConfig($mode);
        $this->config->save();
        $this->flushCache();
        $this->config->save();
        $this->flushCache();
        $this->config->save();
        $this->flushCache();
    }

    /**
     * @return array
     */
    public function getShippingAddress()
    {
        return [
            'firstname' => 'test',
            'lastname' => 'send',
            'street' => 'Michigan Street',
            'city' => 'Michigan City',
            'country_id' => 'US',
            'region_id' => '33',
            'region' => 'xxx',
            'postcode' => '12345',
            'telephone' => '555555',
            'save_in_address_book' => 0,
        ];
    }

    /**
     * @param $customerEmail
     * @return array
     */
    public function getCustomerData($customerEmail)
    {
        return [
            'firstname' => "test",
            'lastname' => "send",
            'email' => $customerEmail,
            'isGuest' => false
        ];
    }

    /**
     * @return void
     */
    public function flushCache()
    {
        $this->cacheManager->flush($this->cacheManager->getAvailableTypes());
    }

    private function saveCoreConfig($mode)
    {
        $this->config->setDataByPath("sagepaysuite/global/currency", SageConfig::CURRENCY_BASE);
        $this->config->setDataByPath("currency/options/base", "USD");
        $this->config->setDataByPath("currency/options/default", "USD");
        $this->config->setDataByPath("currency/options/allow", "USD");
        $this->config->setDataByPath("sagepaysuite/global/mode", SageConfig::MODE_TEST);
        $this->config->setDataByPath("sagepaysuite/global/repeat_transaction", 0);
        $this->config->setDataByPath("payment/sagepaysuitepi/active", 1);
        $this->config->setDataByPath("sagepaysuite/global/vendorname", 'testebizmarts');
        $this->config->setDataByPath("sagepaysuite/global/reporting_user", self::TEST_REPORTING_USERNAME);
        $this->config->setDataByPath("payment/sagepaysuitepi/key", self::TEST_API_KEY);

        if ($mode === SageConfig::ACTION_DEFER_PI) {
            $this->config->setDataByPath("sagepaysuite/advanced/fraud_autoinvoice", 1);
            $this->config->setDataByPath("sagepaysuite/global/fraud_autoinvoice_score", 80);
        }

        if ($mode === SageConfig::ACTION_PAYMENT_PI) {
            $this->config->setDataByPath("sagepaysuite/global/sync_order", 1);
        }
        $this->config->setDataByPath("payment/sagepaysuitepi/payment_action", $mode);
    }
}
