<?php

namespace Ebizmarts\SagePaySuite\Test\Integration;

use Ebizmarts\SagePaySuite\Model\Config as SageConfig;
use Ebizmarts\SagePaySuite\Model\CryptAndCodeData;
use Ebizmarts\SagePaySuite\Test\PlaceMagentoOrder;
use Ebizmarts\SagePaySuite\Test\Api\Helper;
use Magento\Config\Model\Config;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\ObjectManager;
use Ebizmarts\SagePaySuite\Test\Helper\CreateOrder as HelperCreateOrder;

class CreatePiOrderFraudCheckTest extends \PHPUnit\Framework\TestCase
{
    /** @var PlaceMagentoOrder $placeMagentoOrder */
    private $placeMagentoOrder;

    /** @var Config $config */
    private $config;

    /** @var ObjectManager $objectManager */
    private $objectManager;

    /** @var CryptAndCodeData $cryptAndCode */
    private $cryptAndCode;

    /** @var Helper $helper */
    private $helper;

    /** @var HelperCreateOrder $helperCreateOrder */
    private $helperCreateOrder;

    /**
     * @throws \Exception
     */
    public function setUp() : void
    {
        $this->objectManager = Bootstrap::getObjectManager();
        $this->placeMagentoOrder = $this->objectManager->create(
            PlaceMagentoOrder::class
        );

        $this->config = $this->objectManager->create(
            Config::class
        );
        $this->cryptAndCode = $this->objectManager->create(
            CryptAndCodeData::class
        );
        $this->helperCreateOrder = $this->objectManager->create(
            HelperCreateOrder::class
        );
        $this->helper = $this->objectManager->create(Helper::class);
        $this->helperCreateOrder->saveConfig(SageConfig::ACTION_DEFER_PI);
        $this->helper->saveReportingApiPassword();
        $this->helper->saveReportingApiUser();
        $this->helper->savePiPassword();
        $this->helper->savePiKey();
        $this->helperCreateOrder->flushCache();
    }

    /**
     * @magentoApiDataFixture Ebizmarts/SagePaySuite/_files/customer_add_to_cart.php
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function testCreateOrder()
    {
        $orderData = [
            'currency_id' => 'USD',
            'email' => 'testFraudCheck@ebizmarts.com',
            'shipping_address' => $this->helperCreateOrder->getShippingAddress(),
            'items' => [
                [
                    'product_id' => 2,
                    'qty' => 1,
                    'price' => 20
                ]
            ]
        ];

        $customerData = $this->helperCreateOrder->getCustomerData("testFraudCheck@ebizmarts.com");
        $resultOrder = $this->placeMagentoOrder->createOrder($orderData, $customerData);
        $orderId = $resultOrder['order_id'];
        $orderId = $this->cryptAndCode->decodeAndDecrypt($orderId);
        $this->assertNotNull($orderId);
    }
}
