<?php

namespace Ebizmarts\SagePaySuite\Test\Integration;

use Ebizmarts\SagePaySuite\Api\Data\SyncOrderInterface;
use Ebizmarts\SagePaySuite\Cron\GetInfoSyncFromApi;
use Ebizmarts\SagePaySuite\Model\SyncFromApi;
use Magento\Sales\Model\ResourceModel\Order\CollectionFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\ObjectManager;

class UpdateSyncOrderTableTest extends \PHPUnit\Framework\TestCase
{
    /** @var SyncFromApi $syncFromApi */
    private $syncFromApi;

    /** @var GetInfoSyncFromApi $cronjob */
    private $cronjob;

    /** @var ObjectManager $objectManager */
    private $objectManager;

    /** @var CollectionFactory */
    private $orderCollectionFactory;

    /**
     * @throws \Exception
     */
    public function setUp() : void
    {
        $this->objectManager = Bootstrap::getObjectManager();
        $this->syncFromApi = $this->objectManager->create(
            SyncFromApi::class
        );
        $this->cronjob = $this->objectManager->create(
            GetInfoSyncFromApi::class
        );
        $this->orderCollectionFactory = $this->objectManager->create(
            CollectionFactory::class
        );
    }

    /**
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function testExecuteCronjob()
    {
        $customerEmailId = "testSendToCart@ebizmarts.com";
        $customerOrder = $this->orderCollectionFactory->create()
            ->addAttributeToFilter('customer_email', $customerEmailId)
            ->load();
        $orders = $customerOrder->getData();
        $this->cronjob->process();

        foreach ($orders as $order) {
            $orderId = $order['entity_id'];
            /** @var SyncOrderInterface $syncedOrder */
            $syncedOrder = $this->syncFromApi->getByOrderId($orderId);
            $this->assertEquals($orderId, $syncedOrder->getOrderId());
        }
    }
}
