<?php
namespace Expedux\AllCronJobs\Console;
use Magento\Framework\App\ResourceConnection;
use Expedux\AllCronJobs\Model\ExpiredProducts;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class OroCommon extends Command
{
    const NAME_ARGUMENT = "oro_cron";
    public function __construct(
        \Expedux\AllCronJobs\Model\ExpiredProducts $ExpiredProducts,
        \Expedux\AllCronJobs\Model\OroSyncOrder $orosyncorder,
        \Expedux\AllCronJobs\Model\OroContactImports $orocontactimport,
        \Expedux\AllCronJobs\Model\OroContactAccount $orocontactaccount,        
        \Expedux\AllCronJobs\Model\OroContactCommPref $orocontactcommpref,
        \Magento\Customer\Model\CustomerFactory $customerfactory,
        ResourceConnection $resourceConnection,       
        $name = null
    ) {
        $this->ExpiredProducts = $ExpiredProducts;
        $this->orosyncorder = $orosyncorder;
        $this->orocontactimport = $orocontactimport;
        $this->orocontactaccount = $orocontactaccount;       
        $this->orocontactcommpref = $orocontactcommpref;
        $this->resourceConnection = $resourceConnection; 
        $this->customerfactory = $customerfactory;       
        parent::__construct($name);
    }

    protected function configure()
    {
        $this->setName('expedux:oroconnect');
        $this->setDescription('Cron for oro connection');
        $this->setDefinition([
            new InputArgument(self::NAME_ARGUMENT, InputArgument::OPTIONAL, "Cron Name"),
        ]);

        parent::configure();
    }
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $name = $input->getArgument(self::NAME_ARGUMENT);

        switch ($name) {
            case 'expired_products':
                $this->ExpiredProducts->getExpiredProducts();
                break;  
            case 'oro_sync_order':
                $this->orosyncorder->syncOrders();
                break;
            case 'oro_contact_import':
                $this->orocontactimport->importContacts();
                break;
            case 'oro_contact_account':
                $this->orocontactaccount->importContactAccount();
                break;
            case 'oro_sync_all':
                $this->syncAll();
                break;
            case 'oro_sync_all_pending':
                    $this->syncAllPending();
                    break;
            case 'oro_contact_comm_pref':
                $this->orocontactcommpref->importContactCommPref();
                break;            
        }
        //$output->writeln($name);
    }

    public function syncAllPending()
    {
        $cur_date = date("Y-m-d");
        //$this->state->setAreaCode(Area::AREA_FRONTEND);

        $connection = $this->resourceConnection->getConnection();
        /*$clast_update_sql = "SELECT updated_last_id FROM oro_customer_entity_cron where id=4";
        $order_last_update_id = $connection->fetchOne($clast_update_sql);
        echo $order_last_update_id;
        if (empty($order_last_update_id)) {
            $order_last_update_id = 0;
        }*/
        $order_last_update_id = 11606;
        $sal_entity_sql = "SELECT entity_id, customer_id, customer_email, created_at FROM sales_order
				 WHERE entity_id > '" . $order_last_update_id . "' ORDER BY entity_id limit 0, 1";

        $ordersArr = $connection->fetchAll($sal_entity_sql);
        $inc = 1;
        foreach ($ordersArr as $order) {
            if (!empty($order['customer_id'])) {
                $entityId = $order['entity_id'];
                $customerEmail = $order['customer_email'];

                $maincustomer = $this->customerfactory->create()->load($order['customer_id']);
                $customerArr = array('firstName' => $maincustomer->getFirstname(),
                    'lastName' => $maincustomer->getLastname(),
                    'primaryEmail' => $customerEmail,
                );
                if (!empty($maincustomer->getPrefix())) {$customerArr['namePrefix'] = $maincustomer->getPrefix();}

                $billing_sql = "SELECT customer_address_id, firstname, lastname, street, company, city, region, region_id, postcode, country_id, telephone, fax, suffix FROM sales_order_address where address_type='billing' AND parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $billing = $connection->fetchAll($billing_sql);
                $billingadd = "";
                $billingaddId = "";
                if (!empty($billing)) {
                    $billingaddId = $billing[0]['customer_address_id'];
                    $billingadd = array('firstname' => $billing[0]['firstname'],
                        'lastname' => $billing[0]['lastname'],
                        'street' => $billing[0]['street'],
                        'city' => $billing[0]['city'],
                        'company' => $billing[0]['company'],
                        'postcode' => $billing[0]['postcode'],
                        'country_id' => $billing[0]['country_id'],
                        'telephone' => $billing[0]['telephone'],
                        'region_id' => $billing[0]['region_id'],
                        'region' => $billing[0]['region'],
                        'fax' => $billing[0]['fax'],
                        'suffix' => $billing[0]['suffix'],
                    );
                    if (!empty($billing[0]['telephone'])) {$customerArr['primaryPhone'] = $billing[0]['telephone'];}
                }
                $shippingadd = "";
                $shippingaddId = "";
                $shipping_sql = "SELECT customer_address_id, firstname, lastname, street, city, company, region, region_id, postcode, country_id, telephone, fax, suffix FROM sales_order_address where address_type='shipping' AND parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $shipping = $connection->fetchAll($shipping_sql);
                if (!empty($shipping)) {
                    $shippingaddId = $shipping[0]['customer_address_id'];
                    if (!empty($shippingaddId) && $billingaddId != $shippingaddId) {
                        $shippingadd = array('firstname' => $shipping[0]['firstname'],
                            'lastname' => $shipping[0]['lastname'],
                            'street' => $shipping[0]['street'],
                            'city' => $shipping[0]['city'],
                            'company' => $shipping[0]['company'],
                            'postcode' => $shipping[0]['postcode'],
                            'country_id' => $shipping[0]['country_id'],
                            'telephone' => $shipping[0]['telephone'],
                            'region_id' => $shipping[0]['region_id'],
                            'region' => $shipping[0]['region'],
                            'fax' => $shipping[0]['fax'],
                            'suffix' => $shipping[0]['suffix'],
                        );
                    }
                }
                /*echo "<pre>";print_r($billingadd);print_r($shippingadd);print_r($customerArr);
                echo "<br>".$customerEmail."=".$order['customer_id']."=".$order['created_at']."=".$entityId;
                exit;*/
                $inval = $inc."=".$entityId;
                $this->magentoDetailsImportPending($inval, $customerEmail, $customerArr, $order['customer_id'], $order['created_at'], $billingadd, $shippingadd);
                $inc++;
            }
           
        }
    }
    public function magentoDetailsImportPending($inval, $customerEmail, $customerArr, $customerId, $created_at, $billingadd, $shippingadd)
    {
        $username = 'root';
        $apiUserKey = '0a9b22da6266bd33d20056598e414e51a9afe0c2';
        $url =  "https://orocrm.spoce.com/api/";
        //$url =  "http://spocelive.com/api/";
        $contactId ="";
        $accountId ="";
        if(!empty($customerEmail))
        {
            //$customerEmail = "anisidress04@hotmail.com";
            $apicall = "magentocustomers?filter[email]=".$customerEmail."&page[number]=1&page[size]=1&sort=id";
            $magentoCustomerId = $this->oroMagentoCustomerCurlRequset($url, $apicall, $username, $apiUserKey);
            //echo "fff".$magentoCustomerId."<br>";exit;
            //echo $customerEmail;
            if(empty($magentoCustomerId)){
                $apicall = "contacts?filter[emails]=".$customerEmail."&page[number]=1&page[size]=1&sort=id";
                $contactId = $this->oroGetContactRequset($url, $apicall, $username, $apiUserKey);
                //echo $contactId."contact id<br>";		
                //exit;
                $accountId = $this->oroGetAccountFromContactRequst($url, $apicall, $username, $apiUserKey);
                if(empty($accountId)){
                    $accountName = array ('name' => $customerArr['firstName'].' '.$customerArr['lastName'],
                    'createdAt' =>str_replace(" ","T",$created_at)."Z", 'updatedAt' =>str_replace(" ","T",$created_at)."Z");                                				
                    $accountId = $this->oroAccountImport($accountName, $url, $apicall, $username, $apiUserKey);
                }    
                    //echo "ddd".$accountId;exit;
                    //$accountId = 2821;
                if(empty($contactId)){
                    $newContactId = $this->oroContactImport($customerArr, $accountId, $customerId, $created_at, $url, $apicall, $username, $apiUserKey);	
                    /*$up_qry = "UPDATE oro_contact_comm_pref SET sent ='1' WHERE customer_id = '".$customerId."'";
                    $connection->query($up_qry);*/
                }else{
                    $newContactId = $contactId;
                }                    
                if(!empty($newContactId)){                    
                    //$newContactId = 23427;
                    //echo $newContactId."<br>";
                    if(!empty($shippingadd)){
                        $newBillingId = $this->oroAddressImport($newContactId, $billingadd, 'billing', $url, $apicall, $username, $apiUserKey);	
                        $newShippingId = $this->oroAddressImport($newContactId, $shippingadd, 'shipping', $url, $apicall, $username, $apiUserKey);
                    }else{ 
                        $newBillingId = $this->oroAddressImport($newContactId, $billingadd, 'both', $url, $apicall, $username, $apiUserKey);
                    }
                    //echo $newBillingId."=";exit;
                   // $newBillingId ='10274';
                    //$newBillingId ='10274';
                    $magCustomerArr = array ( 'firstName' => $customerArr['firstName'],
                    'lastName' => $customerArr['lastName'], 	
                    'email' => $customerArr['primaryEmail'],
                    'createdIn' => "SPOCE Project Management Ltd",
                    'lifetime' => "0.0000",
                    'currency' => "GBP",
                    'createdAt' => $created_at,
                    'updatedAt' => $created_at,
                    'importedAt' => $created_at,
                    'confirmed' => true,
                    'guest' => false,
                    'isActive' => false,
                    'originId' => $customerId
                    );
                    if(!empty($customerArr['namePrefix'])) { $magCustomerArr['namePrefix'] = $customerArr['namePrefix'];}
                    $magCustomerId = $this->oroMagCustomerImport($magCustomerArr, $newContactId, $accountId, $url, $apicall, $username, $apiUserKey);	
                    //echo $magCustomerId;
                    if(!empty($shippingadd)){
                        $magBillingId = $this->oroMagAddressImport($magCustomerId, $billingadd, $newBillingId, 'billing', $url, $apicall, $username, $apiUserKey);	
                        $magShippingId =  $this->oroMagAddressImport($magCustomerId, $shippingadd, $newShippingId, 'shipping', $url, $apicall, $username, $apiUserKey);
                    }else{ 
                        $magBillingId = $this->oroMagAddressImport($magCustomerId, $billingadd, $newBillingId, 'both', $url, $apicall, $username, $apiUserKey);
                    }
                }                                 			
            }
            echo $inval."=".$magentoCustomerId."=".$contactId."=".$accountId."\n";            
        }
    }

    public function syncAll()
    {
        $cur_date = date("Y-m-d");
        //$this->state->setAreaCode(Area::AREA_FRONTEND);

        $connection = $this->resourceConnection->getConnection();
        $clast_update_sql = "SELECT updated_last_id FROM oro_customer_entity_cron where id=4";
        $order_last_update_id = $connection->fetchOne($clast_update_sql);
        //echo $order_last_update_id;
        if (empty($order_last_update_id)) {
            $order_last_update_id = 0;
        }
        
        $sal_entity_sql = "SELECT entity_id, customer_id, customer_email, created_at FROM sales_order
				 WHERE entity_id > '" . $order_last_update_id . "' ORDER BY entity_id limit 0, 25";

        $ordersArr = $connection->fetchAll($sal_entity_sql);
        //print_r($ordersArr);exit;
        $inc = 1;
        foreach ($ordersArr as $order) {
            if (!empty($order['customer_id'])) {
                $entityId = $order['entity_id'];
                $customerEmail = $order['customer_email'];

                $maincustomer = $this->customerfactory->create()->load($order['customer_id']);
                $customerArr = array('firstName' => $maincustomer->getFirstname(),
                    'lastName' => $maincustomer->getLastname(),
                    'primaryEmail' => $customerEmail,
                );
                if (!empty($maincustomer->getPrefix())) {$customerArr['namePrefix'] = $maincustomer->getPrefix();}

                $billing_sql = "SELECT customer_address_id, firstname, lastname, street, company, city, region, region_id, postcode, country_id, telephone, fax, suffix FROM sales_order_address where address_type='billing' AND parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $billing = $connection->fetchAll($billing_sql);
                $billingadd = "";
                $billingaddId = "";
                if (!empty($billing)) {
                    $billingaddId = $billing[0]['customer_address_id'];
                    $billingadd = array('firstname' => $billing[0]['firstname'],
                        'lastname' => $billing[0]['lastname'],
                        'street' => $billing[0]['street'],
                        'city' => $billing[0]['city'],
                        'company' => $billing[0]['company'],
                        'postcode' => $billing[0]['postcode'],
                        'country_id' => $billing[0]['country_id'],
                        'telephone' => $billing[0]['telephone'],
                        'region_id' => $billing[0]['region_id'],
                        'region' => $billing[0]['region'],
                        'fax' => $billing[0]['fax'],
                        'suffix' => $billing[0]['suffix'],
                    );
                    if (!empty($billing[0]['telephone'])) {$customerArr['primaryPhone'] = $billing[0]['telephone'];}
                }
                $shippingadd = "";
                $shippingaddId = "";
                $shipping_sql = "SELECT customer_address_id, firstname, lastname, street, city, company, region, region_id, postcode, country_id, telephone, fax, suffix FROM sales_order_address where address_type='shipping' AND parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $shipping = $connection->fetchAll($shipping_sql);
                if (!empty($shipping)) {
                    $shippingaddId = $shipping[0]['customer_address_id'];
                    if (!empty($shippingaddId) && $billingaddId != $shippingaddId) {
                        $shippingadd = array('firstname' => $shipping[0]['firstname'],
                            'lastname' => $shipping[0]['lastname'],
                            'street' => $shipping[0]['street'],
                            'city' => $shipping[0]['city'],
                            'company' => $shipping[0]['company'],
                            'postcode' => $shipping[0]['postcode'],
                            'country_id' => $shipping[0]['country_id'],
                            'telephone' => $shipping[0]['telephone'],
                            'region_id' => $shipping[0]['region_id'],
                            'region' => $shipping[0]['region'],
                            'fax' => $shipping[0]['fax'],
                            'suffix' => $shipping[0]['suffix'],
                        );
                    }
                }
                /*echo "<pre>";print_r($billingadd);print_r($shippingadd);print_r($customerArr);
                echo "<br>".$customerEmail."=".$order['customer_id']."=".$order['created_at']."=".$entityId;
                exit;*/
                $this->magentoDetailsImport($customerEmail, $customerArr, $order['customer_id'], $order['created_at'], $billingadd, $shippingadd);
                //exit;
                if ($entityId > $order_last_update_id) {
                    $last_change_query = "UPDATE oro_customer_entity_cron SET updated_last_id = '" . $entityId . "' WHERE id ='4'";
                    $connection->query($last_change_query);
                }
            }            
        }
    }
    public function magentoDetailsImport($customerEmail, $customerArr, $customerId, $created_at, $billingadd, $shippingadd)
    {
        $username = 'root';
        $apiUserKey = '0a9b22da6266bd33d20056598e414e51a9afe0c2';
        $url =  "https://orocrm.spoce.com/api/";
        //$url =  "http://spocelive.com/api/";
        if(!empty($customerEmail))
        {
            //$customerEmail = "anisidress04@hotmail.com";
            $apicall = "magentocustomers?filter[email]=".$customerEmail."&page[number]=1&page[size]=1&sort=id";
            $magentoCustomerId = $this->oroMagentoCustomerCurlRequset($url, $apicall, $username, $apiUserKey);
            //echo "fff".$magentoCustomerId."<br>";exit;
            //echo $customerEmail;
            if(empty($magentoCustomerId)){
                $apicall = "contacts?filter[emails]=".$customerEmail."&page[number]=1&page[size]=1&sort=id";
                $contactId = $this->oroGetContactRequset($url, $apicall, $username, $apiUserKey);
                //echo $contactId."contact id<br>";		
                //exit;
                $accountId = $this->oroGetAccountFromContactRequst($url, $apicall, $username, $apiUserKey);
                if(empty($accountId)){
                    $accountName = array ('name' => $customerArr['firstName'].' '.$customerArr['lastName'],
                    'createdAt' =>str_replace(" ","T",$created_at)."Z", 'updatedAt' =>str_replace(" ","T",$created_at)."Z");                                				
                    $accountId = $this->oroAccountImport($accountName, $url, $apicall, $username, $apiUserKey);                
                }    
                    //echo "ddd".$accountId;exit;
                    //$accountId = 2821;
                    if(empty($contactId)){
                        $connection = $this->resourceConnection->getConnection();
                        $newContactId = $this->oroContactImport($customerArr, $accountId, $customerId, $created_at, $url, $apicall, $username, $apiUserKey);	
                        $up_qry = "UPDATE oro_contact_comm_pref SET sent ='1' WHERE customer_id = '".$customerId."'";
                        $connection->query($up_qry);
                    }else{
                        $newContactId = $contactId;
                    }
                    
                if(!empty($newContactId)){
                    
                    //$newContactId = 23427;
                    //echo $newContactId."<br>";
                    if(!empty($shippingadd)){
                        $newBillingId = $this->oroAddressImport($newContactId, $billingadd, 'billing', $url, $apicall, $username, $apiUserKey);	
                        $newShippingId = $this->oroAddressImport($newContactId, $shippingadd, 'shipping', $url, $apicall, $username, $apiUserKey);
                    }else{ 
                        $newBillingId = $this->oroAddressImport($newContactId, $billingadd, 'both', $url, $apicall, $username, $apiUserKey);
                    }
                    //echo $newBillingId."=";exit;
                   // $newBillingId ='10274';
                    //$newBillingId ='10274';
                    $magCustomerArr = array ( 'firstName' => $customerArr['firstName'],
                    'lastName' => $customerArr['lastName'], 	
                    'email' => $customerArr['primaryEmail'],
                    'createdIn' => "SPOCE Project Management Ltd",
                    'lifetime' => "0.0000",
                    'currency' => "GBP",
                    'createdAt' => $created_at,
                    'updatedAt' => $created_at,
                    'importedAt' => $created_at,
                    'confirmed' => true,
                    'guest' => false,
                    'isActive' => false,
                    'originId' => $customerId
                    );
                    if(!empty($customerArr['namePrefix'])) { $magCustomerArr['namePrefix'] = $customerArr['namePrefix'];}
                    $magCustomerId = $this->oroMagCustomerImport($magCustomerArr, $newContactId, $accountId, $url, $apicall, $username, $apiUserKey);	
                    //echo $magCustomerId;
                    if(!empty($shippingadd)){
                        $magBillingId = $this->oroMagAddressImport($magCustomerId, $billingadd, $newBillingId, 'billing', $url, $apicall, $username, $apiUserKey);	
                        $magShippingId =  $this->oroMagAddressImport($magCustomerId, $shippingadd, $newShippingId, 'shipping', $url, $apicall, $username, $apiUserKey);
                    }else{ 
                        $magBillingId = $this->oroMagAddressImport($magCustomerId, $billingadd, $newBillingId, 'both', $url, $apicall, $username, $apiUserKey);
                    }
                }	 			
            }
        }
    }
    public function oroMagentoCustomerCurlRequset($url, $apicall, $username, $apiUserKey)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET'); //LET OP!! PATCH voor updates!!
        //curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);
        //echo "<pre>";
        //print_r($output);exit;
        curl_close($ch);
        if(isset($output->data[0]->id) && !empty($output->data[0]->id))
        {
            return $output->data[0]->id;
        }else{
            return;
        }
    }

    public function oroGetContactRequset($url, $apicall, $username, $apiUserKey)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET'); //LET OP!! PATCH voor updates!!
        //curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);
        //echo "<pre>"; print_r($output);
        curl_close($ch);
        if(isset($output->data[0]->id) && !empty($output->data[0]->id)) {
            return $output->data[0]->id;		
        }else{
            return;
        }
    }

    public function oroGetAccountFromContactRequst($url, $apicall, $username, $apiUserKey)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET'); //LET OP!! PATCH voor updates!!
        //curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsdata));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);
        //echo "<pre>"; print_r($output);
        curl_close($ch);
        if(isset($output->data[0]->relationships->accounts->data[0]->id) && !empty($output->data[0]->relationships->accounts->data[0]->id)) {
            return $output->data[0]->relationships->accounts->data[0]->id;		
        }else{
            return;
        }
    }

    public function oroAccountImport($accountName, $url, $apicall, $username, $apiUserKey)
    {
        $apicall = "accounts";
        $relationships = array (
            'owner' => array ('data' => array ("type" =>"users", "id" => "1"))
            );
            // php array with data to update main entity
            $accountsInfo =   array ( 'data' => array ('type' => 'accounts' ,
                'attributes' => $accountName,
                'relationships' => $relationships
                ));	
                //echo "<pre>";print_r($accountsInfo);exit;			
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url.$apicall);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($accountsInfo));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
                $output = curl_exec($ch);
                $output = json_decode($output);	
                //echo "<pre>";print_r($output);		
                curl_close($ch);
                if(!empty($output->data->id))
                {
                    return $output->data->id;
                }else{
                    return;
                }
    }

    function oroContactImport($customerArr, $accountId, $customerId, $created_at, $url, $apicall, $username, $apiUserKey)
    {
        $apicall = "contacts";
        $customerArr['createdAt'] = $created_at;
        $customerArr['updatedAt'] = $created_at;
        $connection = $this->resourceConnection->getConnection();
        $comm_prefs_sql = "SELECT comm_pref FROM oro_contact_comm_pref where customer_id='".$customerId."'";
        $comm_prefs = $connection->fetchOne($comm_prefs_sql);
        
        $comm_preferences = array();
        $comm_preferences_id = 'contactcommunicationprefer71f420a4s';
        if(!empty($comm_prefs))
        {
            $comm_prefs_arr = explode(',', $comm_prefs);		
            if(count($comm_prefs_arr) > 0)
            {					
            $inc = 0;						
            foreach($comm_prefs_arr as $comm) {			
                    if($comm == 'email') { 
                        $comm_preferences[$inc]['type'] = $comm_preferences_id;
                        $comm_preferences[$inc]['id'] = 'email';					
                    }
                    if($comm == 'phone') { 
                        $comm_preferences[$inc]['type'] = $comm_preferences_id;
                        $comm_preferences[$inc]['id'] = 'phone';					
                    }
                    if($comm == 'im') { 
                        $comm_preferences[$inc]['type'] = $comm_preferences_id;
                        $comm_preferences[$inc]['id'] = 'im';					
                    }
                    if($comm == 'post') { 
                        $comm_preferences[$inc]['type'] = $comm_preferences_id;
                        $comm_preferences[$inc]['id'] = 'post';					
                    }
                
                    if($comm == 'approved_partners') {
                    $comm_preferences[$inc]['type'] = $comm_preferences_id;
                    $comm_preferences[$inc]['id'] = 'approved_partners';			    
                    }
                    $inc++;	
                }
            }
        }
        
        if(empty($comm_preferences)){
            $comm_preferences[0]['type'] = $comm_preferences_id;
            $comm_preferences[0]['id'] = 'email';				
            
            $comm_preferences[1]['type'] = $comm_preferences_id;
            $comm_preferences[1]['id'] = 'phone';
        }
        
        $relationships = array (
            'organization' => array ('data' => array ("type" =>"organizations", "id" => "1")),
            'owner' => array ('data' => array ("type" =>"users", "id" => "1")),
            'accounts' => array ('data' => array (array ("type" =>"accounts", "id" => "$accountId"))),
            'CommunicationPrefer' => array ('data' => $comm_preferences),
            );

            // php array with data to update main entity
            $contacts =   array ( 'data' => array ('type' => 'contacts' ,
                'attributes' => $customerArr,
                'relationships' => $relationships
                ));	
                //echo "<pre>";print_r($contacts);			
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url.$apicall);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contacts));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
                $output = curl_exec($ch);
                $output = json_decode($output);	
                //echo "<pre>";print_r($output);
                //exit;		
                curl_close($ch);
                if(!empty($output->data->id))
                {
                    return $output->data->id;
                }else{
                    return;
                }
    }

    public function oroAddressImport($contactId, $address, $addtype, $url, $apicall, $username, $apiUserKey) {	
        $apicall = "contactaddresses";
        $country = $address['country_id'];
        $is_primary = false;
        if($addtype == 'both'){
        $addressType = array ('data' => array (array ("type" =>"addresstypes", "id" => "billing"),
                                        array ("type" =>"addresstypes", "id" => "shipping")));
        //$is_primary = true;								
        }else{
            $addressType = array ('data' => array (array ("type" =>"addresstypes", "id" => "$addtype")));
           // if($addtype == 'billing') $is_primary = true;	
        }
        
        if($address['region'] && $country == "GB"){			
            $region_text = str_replace("88","",$this->getstates($address['region']));
        }else{
            $region_text = '';
        }
        if(!empty($region_text))
        {	
        $contactsaddress =   array ( 'data' => array ('type' => 'contactaddresses',
                'attributes' => array ( "primary" => $is_primary,
                        "street" => $address['street'],
                        "street2" => '',
                        "city" => $address['city'],
                        "postalCode" => $address['postcode'],
                        "firstName" => $address['firstname'],
                        "lastName" => $address['lastname'],
                        //"fax" => $address['fax'],
                        "organization" => $address['suffix'],
                        //"delegate_email" => $address['company'] 
                    ),
                        'relationships' => array (
                        'owner' => array ('data' => array ("type" =>"contacts", "id" => "$contactId")),
                        'country' => array ('data' => array ("type" =>"countries", "id" => "$country")),
                        'region' => array ('data' => array ("type" =>"regions", "id" => "$region_text")),
                        'types' => $addressType,
                )
        ));
        }else{
            $contactsaddress =   array ( 'data' => array ('type' => 'contactaddresses',
                    'attributes' => array ( "primary" => $is_primary,
                            "street" => $address['street'],
                            "street2" => '',
                            "city" => $address['city'],
                            "postalCode" => $address['postcode'],
                            "firstName" => $address['firstname'],
                            "lastName" => $address['lastname'] ,
                            //"fax" => $address['fax'],
                            "organization" => $address['suffix'],
                            //"delegate_email" => $address['company']
                        ),
                    'relationships' => array (
                            'owner' => array ('data' => array ("type" =>"contacts", "id" => "$contactId")),
                            'country' => array ('data' => array ("type" =>"countries", "id" => "$country")),
                            'types' => $addressType,
                    )
            ));	
        }
        //echo "<pre>";print_r($contactsaddress);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($contactsaddress));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);	
        //print_r($output);exit;		
        curl_close($ch);
        if(!empty($output->data->id))
        {
            return $output->data->id;
        }else{
            return;
        }	
    }

    function oroMagCustomerImport($customerArr, $contactId, $accountId, $url, $apicall, $username, $apiUserKey)
    {   
        $apicall = "magentocustomers";
        $relationships = array (
            'website' => array ('data' => array ("type" =>"magentowebsites", "id" => "2")),
            'store' => array ('data' => array ("type" =>"magentostores", "id" => "2")),
            'contact' => array ('data' => array ("type" =>"contacts", "id" => "$contactId")),
            'account' => array ('data' => array ("type" =>"accounts", "id" => "$accountId")),
            'organization' => array ('data' => array ("type" =>"organizations", "id" => "1")),
            //'group' => array ('data' => array ("type" =>"magentocustomergroup", "id" => "2")),
            'owner' => array ('data' => array ("type" =>"users", "id" => "1")),
            'channel' => array ('data' => array ("type" =>"integrationchannels", "id" => "1")),
            'dataChannel' => array ('data' => array ("type" =>"channels", "id" => "1")),
            );
            // php array with data to update main entity
            $magentocustomer =   array ( 'data' => array ('type' => 'magentocustomers' ,
                'attributes' => $customerArr,
                'relationships' => $relationships
                ));	
                //echo "<pre>";print_r($magentocustomer);		
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url.$apicall);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($magentocustomer));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
                $output = curl_exec($ch);
                //echo json_encode($magentocustomer);
                //echo "<pre>";print_r($output);
                $output = json_decode($output);	
                    
                //exit;	
                curl_close($ch);
                if(!empty($output->data->id))
                {
                    return $output->data->id;
                }else{
                    return;
                }
    }

    function oroMagAddressImport($magCustomerId, $address, $addId, $addtype, $url, $apicall, $username, $apiUserKey) {	
        $apicall = "magentoaddresses";
        $country = $address['country_id'];
        $is_primary = false;
        if($addtype == 'both'){
        $addressType = array ('data' => array (array ("type" =>"addresstypes", "id" => "billing"),
                                        array ("type" =>"addresstypes", "id" => "shipping")));
        $is_primary = true;								
        }else{
            $addressType = array ('data' => array (array ("type" =>"addresstypes", "id" => "$addtype")));
            if($addtype == 'billing') $is_primary = true;	
        }
        if($address['region'] && $country == "GB"){			
            $region_text = str_replace("88","",$this->getstates($address['region']));
        }else{
            $region_text = '';
        }
        if(!empty($region_text))
        {	
        $magCustomerAddress =   array ( 'data' => array ('type' => 'magentoaddresses',
                        'attributes' => array ( "primary" => $is_primary,
                        "street" => $address['street'],
                        "street2" => '',
                        "city" => $address['city'],
                        "postalCode" => $address['postcode'],
                        "firstName" => $address['firstname'],
                        "lastName" => $address['lastname'],
                        "phone" => $address['telephone'] ),
                        'relationships' => array (
                        'owner' => array ('data' => array ("type" =>"magentocustomers", "id" => "$magCustomerId")),
                        'contactAddress' => array ('data' => array ("type" =>"contactaddresses", "id" => "$addId")),
                        'country' => array ('data' => array ("type" =>"countries", "id" => "$country")),
                        'region' => array ('data' => array ("type" =>"regions", "id" => "$region_text")),
                        'types' => $addressType,
                )
        ));
        }else{
            $magCustomerAddress =   array ( 'data' => array ('type' => 'magentoaddresses',
                            'attributes' => array ( "primary" => $is_primary,
                            "street" => $address['street'],
                            "street2" => '',
                            "city" => $address['city'],
                            "postalCode" => $address['postcode'],
                            "firstName" => $address['firstname'],
                            "lastName" => $address['lastname'],
                            "phone" => $address['telephone'] ),
                            'relationships' => array (
                            'owner' => array ('data' => array ("type" =>"magentocustomers", "id" => "$magCustomerId")),
                            'contactAddress' => array ('data' => array ("type" =>"contactaddresses", "id" => "$addId")),
                            'country' => array ('data' => array ("type" =>"countries", "id" => "$country")),
                            'types' => $addressType,
                    )
            ));	
        }
        //echo "<pre>";print_r($magCustomerAddress);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url.$apicall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST'); //LET OP!! PATCH voor updates!!
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($magCustomerAddress));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $this->oroWsseheader($username, $apiUserKey));
        $output = curl_exec($ch);
        $output = json_decode($output);	
        //print_r($output);exit;		
        curl_close($ch);
        if(!empty($output->data->id))
        {
            return $output->data->id;
        }else{
            return;
        }	
    }

    public function oroWsseheader($userName, $userPassword)
    {
        $nonce = uniqid();
        $created  = date('c');
        $digest   = base64_encode(sha1(base64_decode($nonce) . $created . $userPassword, true));
        $wsseHeader = array();
        //$wsseHeader[] = "Accept: application/json";
        $wsseHeader[] = "Content-Type: application/vnd.api+json";
        $wsseHeader[] = "Authorization: WSSE profile=\"UsernameToken\"";
        $code = sprintf(
                'X-WSSE: UsernameToken Username="%s", PasswordDigest="%s", Nonce="%s", Created="%s"',
                $userName,
                $digest,
                $nonce,
                $created
        );
        $wsseHeader[] = $code;
        return $wsseHeader;
    }
    public function getstates($state)
    { 
        $stateArr = array (
                "GB-ABE" => "Aberdeen City",
                "GB-ABD" => "Aberdeenshire",
                "GB-ANS" => "Angus",
                "GB-ANT" => "Antrim",
                "GB-ARD" => "Ards",
                "GB-AGB" => "Argyll and Bute",
                "GB-ARM" => "Armagh",
                "GB-BLA" => "Ballymena",
                "GB-BLY" => "Ballymoney",
                "GB-BNB" => "Banbridge",
                "GB-BDG" => "Barking and Dagenham",
                "GB-BNE" => "Barnet",
                "GB-BNS" => "Barnsley",
                "GB-BDF" => "Bedford",
                "GB-BFS" => "Belfast",
                "GB-BEX" => "Bexley",
                "GB-BIR" => "Birmingham",
                "GB-BBD" => "Blackburn with Darwen",
                "GB-BPL" => "Blackpool",
                "GB-BGW" => "Blaenau Gwent",
                "GB-BOL" => "Bolton",
                "GB-BMH" => "Bournemouth",
                "GB-BRC" => "Bracknell Forest",
                "GB-BRD" => "Bradford",
                "GB-BEN" => "Brent",
                "GB-BNH" => "Brighton and Hove",
                "GB-BST" => "Bristol, City of",
                "GB-BRY" => "Bromley",
                "GB-BKM" => "Buckinghamshire",
                "GB-BUR" => "Bury",
                "GB-CLD" => "Calderdale",
                "GB-CAM" => "Cambridgeshire",
                "GB-CMD" => "Camden",
                "GB-CKF" => "Carrickfergus",
                "GB-CSR" => "Castlereagh",
                "GB-CBF" => "Central Bedfordshire",
                "GB-CHE" => "Cheshire East",
                "GB-CHW" => "Cheshire West and Chester",
                "GB-CLK" => "Clackmannanshire",
                "GB-CLR" => "Coleraine",
                "GB-CWY" => "Conwy",
                "GB-CKT" => "Cookstown",
                "GB-CON" => "Cornwall",
                "GB-COV" => "Coventry",
                "GB-CGV" => "Craigavon",
                "GB-CRY" => "Croydon",
                "GB-CMA" => "Cumbria",
                "GB-DAL" => "Darlington",
                "GB-DER" => "Derby",
                "GB-DBY" => "Derbyshire",
                "GB-DRY" => "Derry",
                "GB-DEV" => "Devon",
                "GB-DNC" => "Doncaster",
                "GB-DOR" => "Dorset",
                "GB-DOW" => "Down",
                "GB-DUD" => "Dudley",
                "GB-DGN" => "Dungannon",
                "GB-DUR" => "Durham",
                "GB-EAL" => "Ealing",
                "GB-EAY" => "East Ayrshire",
                "GB-EDU" => "East Dunbartonshire",
                "GB-ELN" => "East Lothian",
                "GB-ERW" => "East Renfrewshire",
                "GB-ERY" => "East Riding of Yorkshire",
                "GB-ESX" => "East Sussex",
                "GB-ELS" => "Eilean Siar",
                "GB-ENF" => "Enfield",
                "GB-EAW" => "England and Wales",
                "GB-ESS" => "Essex",
                "GB-FAL" => "Falkirk",
                "GB-FER" => "Fermanagh",
                "GB-FIF" => "Fife",
                "GB-GAT" => "Gateshead",
                "GB-GLG" => "Glasgow City",
                "GB-GLS" => "Gloucestershire",
                "GB-GBN" => "Great Britain",
                "GB-GRE" => "Greenwich",
                "GB-GWN" => "Gwynedd",
                "GB-HCK" => "Hackney",
                "GB-HAL" => "Halton",
                "GB-HMF" => "Hammersmith and Fulham",
                "GB-HAM" => "Hampshire",
                "GB-HRY" => "Haringey",
                "GB-HRW" => "Harrow",
                "GB-HPL" => "Hartlepool",
                "GB-HAV" => "Havering",
                "GB-HEF" => "Herefordshire",
                "GB-HRT" => "Hertfordshire",
                "GB-HED" => "Highland",
                "GB-HIL" => "Hillingdon",
                "GB-HNS" => "Hounslow",
                "GB-IVC" => "Inverclyde",
                "GB-IOW" => "Isle of Wight",
                "GB-ISL" => "Islington",
                "GB-KEN" => "Kent",
                "GB-KIR" => "Kirklees",
                "GB-KWL" => "Knowsley",
                "GB-LBH" => "Lambeth",
                "GB-LAN" => "Lancashire",
                "GB-LRN" => "Larne",
                "GB-LDS" => "Leeds",
                "GB-LCE" => "Leicester",
                "GB-LEC" => "Leicestershire",
                "GB-LEW" => "Lewisham",
                "GB-LMV" => "Limavady",
                "GB-LIN" => "Lincolnshire",
                "GB-LSB" => "Lisburn",
                "GB-LIV" => "Liverpool",
                "GB-LND" => "London",
                "GB-LND88" => "Greater London",
                "GB-LUT" => "Luton",
                "GB-MFT" => "Magherafelt",
                "GB-MAN" => "Manchester",
                "GB-MDW" => "Medway",
                "GB-MRT" => "Merton",
                "GB-MDB" => "Middlesbrough",
                "GB-MLN" => "Midlothian",
                "GB-MIK" => "Milton Keynes",
                "GB-MRY" => "Moray",
                "GB-MYL" => "Moyle",
                "GB-NET" => "Newcastle upon Tyne",
                "GB-NWM" => "Newham",
                "GB-NYM" => "Newry and Mourne",
                "GB-NTA" => "Newtownabbey",
                "GB-NFK" => "Norfolk",
                "GB-NAY" => "North Ayrshire",
                "GB-NDN" => "North Down",
                "GB-NEL" => "North East Lincolnshire",
                "GB-NLK" => "North Lanarkshire",
                "GB-NLN" => "North Lincolnshire",
                "GB-NSM" => "North Somerset",
                "GB-NTY" => "North Tyneside",
                "GB-NYK" => "North Yorkshire",
                "GB-NTH" => "Northamptonshire",
                "GB-NIR" => "Northern Ireland",
                "GB-NBL" => "Northumberland",
                "GB-NGM" => "Nottingham",
                "GB-NTT" => "Nottinghamshire",
                "GB-OLD" => "Oldham",
                "GB-OMH" => "Omagh",
                "GB-ORR" => "Orkney Islands",
                "GB-OXF" => "Oxfordshire",
                "GB-PKN" => "Perth and Kinross",
                "GB-PTE" => "Peterborough",
                "GB-PLY" => "Plymouth",
                "GB-POL" => "Poole",
                "GB-POR" => "Portsmouth",
                "GB-POW" => "Powys",
                "GB-RDG" => "Reading",
                "GB-RDB" => "Redbridge",
                "GB-RCC" => "Redcar and Cleveland",
                "GB-RFW" => "Renfrewshire",
                "GB-RCH" => "Rochdale",
                "GB-ROT" => "Rotherham",
                "GB-RUT" => "Rutland",
                "GB-SLF" => "Salford",
                "GB-SAW" => "Sandwell",
                "GB-SFT" => "Sefton",
                "GB-SHF" => "Sheffield",
                "GB-ZET" => "Shetland Islands",
                "GB-SHR" => "Shropshire",
                "GB-SLG" => "Slough",
                "GB-SOL" => "Solihull",
                "GB-SOM" => "Somerset",
                "GB-SAY" => "South Ayrshire",
                "GB-SGC" => "South Gloucestershire",
                "GB-SLK" => "South Lanarkshire",
                "GB-STY" => "South Tyneside",
                "GB-STH" => "Southampton",
                "GB-SOS" => "Southend-on-Sea",
                "GB-SWK" => "Southwark",
                "GB-STS" => "Staffordshire",
                "GB-STG" => "Stirling",
                "GB-SKP" => "Stockport",
                "GB-STT" => "Stockton-on-Tees",
                "GB-STE" => "Stoke-on-Trent",
                "GB-STB" => "Strabane",
                "GB-SFK" => "Suffolk",
                "GB-SND" => "Sunderland",
                "GB-SRY" => "Surrey",
                "GB-STN" => "Sutton",
                "GB-SWD" => "Swindon",
                "GB-TAM" => "Tameside",
                "GB-TFW" => "Telford and Wrekin",
                "GB-THR" => "Thurrock",
                "GB-TOB" => "Torbay",
                "GB-TWH" => "Tower Hamlets",
                "GB-TRF" => "Trafford",
                "GB-UKM" => "United Kingdom",
                "GB-WKF" => "Wakefield",
                "GB-WLS" => "Wales",
                "GB-WLL" => "Walsall",
                "GB-WFT" => "Waltham Forest",
                "GB-WND" => "Wandsworth",
                "GB-WRT" => "Warrington",
                "GB-WAR" => "Warwickshire",
                "GB-WBX" => "West Berkshire",
                "GB-WDU" => "West Dunbartonshire",
                "GB-WLN" => "West Lothian",
                "GB-WSX" => "West Sussex",
                "GB-WSM" => "Westminster",
                "GB-WGN" => "Wigan",
                "GB-WNM" => "Windsor and Maidenhead",
                "GB-WRL" => "Wirral",
                "GB-WOK" => "Wokingham",
                "GB-WLV" => "Wolverhampton",
                "GB-WOR" => "Worcestershire",
                "GB-WRX" => "Wrexham;Wrecsam",
                "GB-YOR" => "York");
        $code = array_search (ucfirst($state), $stateArr);
        //$code = array_search ("Greater London", $stateArr);
        return $code;
    }
}
