<?php

namespace Expedux\AllCronJobs\Model;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Model\AbstractModel;
use \Magento\Framework\App\ObjectManager;
use \Magento\Framework\App\State;
use \Magento\Framework\App\Area;
class ExpiredProducts extends AbstractModel
{
    public function __construct(
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Customer\Model\CustomerFactory $customerfactory,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        State $state,
        \Magento\Framework\Registry $registry,
        ResourceConnection $resourceConnection
    ) {
        $this->productFactory = $productFactory;
        $this->customerfactory = $customerfactory;
        $this->_transportBuilder = $transportBuilder;
        $this->_storeManager = $storeManager;
        $this->orderRepository = $orderRepository;
        $this->resourceConnection = $resourceConnection;
        $this->state = $state;
        $registry->register('isSecureArea', true);
       // parent::__construct();
    }
    
	public function getExpiredProducts()
	{
        $cur_date = date("Y-m-d");
        $this->state->setAreaCode(Area::AREA_FRONTEND);

        $connection = $this->resourceConnection->getConnection();

        $entity_sql = "SELECT cpe.entity_id FROM catalog_product_entity as cpe
    	LEFT JOIN catalog_product_entity_datetime as cped ON cpe.entity_id = cped.entity_id
	    LEFT JOIN catalog_product_entity_int as cpei ON cpe.entity_id = cpei.entity_id
    	WHERE cpei.value = 1 AND cped.value < '".$cur_date."' AND cped.attribute_id = 161 AND cpei.attribute_id = 96 AND cpe.attribute_set_id=9";
       $result = $connection->fetchAll($entity_sql);
       $inc = 1;
       if(!empty($result)){
           foreach($result as $key => $value){
               $product = $this->productFactory->create();
               $product->load($value['entity_id'])->setStoreId(0);
               $product->setStatus(2);
               $product->save();
               echo $inc."=".$value['entity_id']."\n";
               $inc++;
           }
       }
       //print_r($result);exit;

	}
   
}