<?php

namespace Expedux\AllCronJobs\Model;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Model\AbstractModel;
use \Magento\Framework\App\Area;
use \Magento\Framework\App\State;

class OroContactCommPref extends AbstractModel
{
    public function __construct(
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Customer\Model\CustomerFactory $customerfactory,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        State $state,
        ResourceConnection $resourceConnection
    ) {
        $this->productFactory = $productFactory;
        $this->customerfactory = $customerfactory;
        $this->_transportBuilder = $transportBuilder;
        $this->_storeManager = $storeManager;
        $this->orderRepository = $orderRepository;
        $this->resourceConnection = $resourceConnection;
        $this->state = $state;
    }

    public function importContactCommPref()
    {
        $cur_date = date("Y-m-d");
        $this->state->setAreaCode(Area::AREA_FRONTEND);

        $connection = $this->resourceConnection->getConnection();
        $cont_sql = "SELECT email,comm_pref FROM oro_contact_comm_pref where sent !=1 and email !=''";
        $contacts = $connection->fetchAll($cont_sql);
        foreach ($contacts as $contact) {

            $customeremail = $contact['email'];

            if (!empty($customeremail)) {

                if (!empty($contact['comm_pref'])) {
                    $comm_prefs = explode(',', $contact['comm_pref']);

                    if (count($comm_prefs) > 0) {
                        $comm_preferences = array();
                        $inc = 0;
                        $comm_preferences_id = 'contactcommunicationprefer71f420a4s';

                        foreach ($comm_prefs as $comm) {

                            if ($comm == 'email') {
                                $comm_preferences[$inc]['type'] = $comm_preferences_id;
                                $comm_preferences[$inc]['id'] = 'email';
                                $inc++;
                            }
                            if ($comm == 'phone') {
                                $comm_preferences[$inc]['type'] = $comm_preferences_id;
                                $comm_preferences[$inc]['id'] = 'phone';
                                $inc++;
                            }
                            if ($comm == 'im') {
                                $comm_preferences[$inc]['type'] = $comm_preferences_id;
                                $comm_preferences[$inc]['id'] = 'im';
                                $inc++;
                            }
                            if ($comm == 'post') {
                                $comm_preferences[$inc]['type'] = $comm_preferences_id;
                                $comm_preferences[$inc]['id'] = 'post';
                                $inc++;
                            }

                            if ($comm == 'approved_partners') {
                                $comm_preferences[$inc]['type'] = $comm_preferences_id;
                                $comm_preferences[$inc]['id'] = 'approved_partners';
                                $inc++;
                            }
                        }

                        // $up_res = oroConnectLogSubscribe($comm_preferences, $customeremail);

                        // if ($up_res == true) {
                        //     $up_qry = "UPDATE oro_contact_comm_pref SET sent ='1' WHERE email = " . $dbWrite->quote($customeremail) . "";
                        //     $connection->query($up_qry);
                        // }

                    }

                }
            }

        }
    }
}
