<?php

namespace Expedux\AllCronJobs\Model;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Model\AbstractModel;
use \Magento\Framework\App\Area;
use \Magento\Framework\App\State;

class OroContactImports extends AbstractModel
{
    public function __construct(
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Customer\Model\CustomerFactory $customerfactory,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        State $state,
        ResourceConnection $resourceConnection
    ) {
        $this->productFactory = $productFactory;
        $this->customerfactory = $customerfactory;
        $this->_transportBuilder = $transportBuilder;
        $this->_storeManager = $storeManager;
        $this->orderRepository = $orderRepository;
        $this->resourceConnection = $resourceConnection;
        $this->state = $state;
    }

    public function importContacts()
    {

        $cur_date = date("Y-m-d");
        $this->state->setAreaCode(Area::AREA_FRONTEND);

        $connection = $this->resourceConnection->getConnection();

        $clast_update_sql = "SELECT updated_last_id FROM oro_customer_entity_cron where id=2";

        $result = $connection->fetchOne($clast_update_sql);
        if (empty($clast_update_id)) {
            $clast_update_id = 1;
        }
        $entity_sql = "SELECT ce.entity_id, ce.email
FROM customer_entity ce
WHERE NOT EXISTS(SELECT * FROM sales_order sfo
                 WHERE ce.entity_id = sfo.customer_id) AND ce.entity_id > '" . $clast_update_id . "' ORDER BY ce.entity_id";
        $customerArr = $connection->fetchAll($entity_sql);

        $inc = 1;
        $cnew_last_update_id = $clast_update_id;
        foreach ($customerArr as $customer) {
            $delegateId = $customer['entity_id'];
            if ($delegateId != 135) {
                $delegateEmail = $customer['email'];
                //echo $delegateId ."=".$delegateEmail."<br>";
                $deladd_sql = "SELECT parent_id, firstname, lastname, street, city, region, region_id, postcode, country_id, telephone
                FROM sales_order_address
                where address_type='shipping' AND company ='" . $delegateEmail . "' ORDER BY entity_id DESC limit 0,1";
                $deladd = $connection->fetchAll($deladd_sql);
                print_r($deladd);exit;
                if (!empty($deladd)) {$order = $this->orderRepository->load($deladd[0]['parent_id']);
                    $maincustomer = $this->customerfactory->create()->load($order->getCustomerId());
                    $mainemail = $maincustomer->getEmail();

                    $add = array('firstname' => $deladd[0]['firstname'],
                        'lastname' => $deladd[0]['lastname'],
                        'street' => $deladd[0]['street'],
                        'city' => $deladd[0]['city'],
                        'company' => $delegateEmail,
                        'postcode' => $deladd[0]['postcode'],
                        'country_id' => $deladd[0]['country_id'],
                        'telephone' => $deladd[0]['telephone'],
                        'region_id' => $deladd[0]['region_id'],
                        'region' => $deladd[0]['region'],
                    );

                    //oroConnectContacts($add, $mainemail);
                }
                if (!empty($deladd)) {
                    $order = $this->orderRepository->load($deladd[0]['order_id']);
                    $maincustomer = $this->customerfactory->create()->load($order->getCustomerId());
                    $mainemail = $maincustomer->getEmail();

                    $add = array('firstname' => $deladd[0]['firstname'],
                        'lastname' => $deladd[0]['lastname'],
                        'street' => $deladd[0]['street'],
                        'city' => $deladd[0]['city'],
                        'company' => $delegateEmail,
                        'postcode' => $deladd[0]['postcode'],
                        'country_id' => $deladd[0]['country_id'],
                        'telephone' => $deladd[0]['telephone'],
                        'region_id' => $deladd[0]['region_id'],
                        'region' => $deladd[0]['region'],
                    );
                    //oroConnectContacts($add, $mainemail);
                }
                if ($cnew_last_update_id > $clast_update_id) {
                    $last_change_query = "UPDATE oro_customer_entity_cron SET updated_last_id = '" . $cnew_last_update_id . "' WHERE id ='2'";
                    $connection->query($last_change_query);
                }
            }
        }
    }
}
