<?php

namespace Expedux\AllCronJobs\Model;

use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Model\AbstractModel;
use \Magento\Framework\App\Area;
use \Magento\Framework\App\State;

class OroSyncOrder extends AbstractModel
{
    public function __construct(
        \Magento\Catalog\Model\ProductFactory $productFactory,
        \Magento\Customer\Model\CustomerFactory $customerfactory,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        State $state,
        ResourceConnection $resourceConnection
    ) {
        $this->productFactory = $productFactory;
        $this->customerfactory = $customerfactory;
        $this->_transportBuilder = $transportBuilder;
        $this->_storeManager = $storeManager;
        $this->orderRepository = $orderRepository;
        $this->resourceConnection = $resourceConnection;
        $this->state = $state;
    }

    public function syncOrders()
    {
        $cur_date = date("Y-m-d");
        $this->state->setAreaCode(Area::AREA_FRONTEND);

        $connection = $this->resourceConnection->getConnection();

        $sal_entity_sql = "SELECT entity_id, coupon_code, created_at, customer_email,  customer_id, discount_amount,
        customer_firstname, increment_id, customer_lastname, remote_ip, shipping_amount, shipping_method, status,
        subtotal, tax_amount, grand_total, total_canceled, total_invoiced, total_paid, total_refunded, updated_at FROM sales_order
        WHERE oro_import !='1' ORDER BY entity_id limit 0,25";

        $result = $connection->fetchAll($sal_entity_sql);
        if (!empty($result)) {
            foreach ($result as $order) {
                $entityId = $order['entity_id'];
                $ordCustomerEmail = $order['customer_email'];

                $incrementId = $order['increment_id'];

                echo $incrementId . '<br />';
                $maincustomer = $this->customerfactory->create()->load($order['customer_id']);
                $customerEmail = $maincustomer->getEmail();
                $billing_sql = "SELECT entity_id, firstname, lastname, company, street, city, region, region_id, postcode, country_id, telephone, fax, suffix FROM sales_order_address where address_type='billing' AND parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $billing = $connection->fetchAll($billing_sql);
                $billingadd = "";
                $billingaddId = "";
                if (!empty($billing)) {
                    $billingaddId = $billing[0]['entity_id'];
                    $billingadd = array('firstname' => $billing[0]['firstname'],
                        'lastname' => $billing[0]['lastname'],
                        'street' => $billing[0]['street'],
                        'city' => $billing[0]['city'],
                        'company' => $billing[0]['company'],
                        'postcode' => $billing[0]['postcode'],
                        'country_id' => $billing[0]['country_id'],
                        'telephone' => $billing[0]['telephone'],
                        'region_id' => $billing[0]['region_id'],
                        'region' => $billing[0]['region'],
                        'fax' => $billing[0]['fax'],
                        'suffix' => $billing[0]['suffix'],
                        'address_id' => $billingaddId,
                    );

                }
                $shippingadd = "";
                $shippingaddId = "";
                $shipping_sql = "SELECT entity_id, firstname, lastname, street, company, city, region, region_id, postcode, country_id, telephone, fax, suffix FROM sales_order_address where address_type='shipping' AND parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $shipping = $connection->fetchAll($shipping_sql);
                if (!empty($shipping)) {
                    $shippingaddId = $shipping[0]['entity_id'];
                    if (!empty($shippingaddId) && $billingaddId != $shippingaddId) {
                        $shippingadd = array('firstname' => $shipping[0]['firstname'],
                            'lastname' => $shipping[0]['lastname'],
                            'street' => $shipping[0]['street'],
                            'city' => $shipping[0]['city'],
                            'company' => $shipping[0]['company'],
                            'postcode' => $shipping[0]['postcode'],
                            'country_id' => $shipping[0]['country_id'],
                            'telephone' => $shipping[0]['telephone'],
                            'region_id' => $shipping[0]['region_id'],
                            'region' => $shipping[0]['region'],
                            'fax' => $shipping[0]['fax'],
                            'suffix' => $shipping[0]['suffix'],
                            'address_id' => $shippingaddId,
                        );
                    }

                }

                $payment_sql = "SELECT entity_id,cc_last_4,cc_type,method FROM sales_order_payment where parent_id ='" . $entityId . "' ORDER BY entity_id DESC limit 0,1";
                $payment_res = $connection->fetchAll($payment_sql);
                $payment = $payment_res[0];
                $payment_details = '';
                if (!empty($payment['cc_last_4'])) {
                    $payment_details = 'Card [' . $payment['cc_type'] . ', ' . $payment['cc_last_4'] . ']';
                }

                $payment_method = $payment['cc_type'];
                $orderinfo = array();
                $orderinfo['couponCode'] = $order['coupon_code'];
                $orderinfo['createdAt'] = $order['created_at'];
                $orderinfo['currency'] = 'GBP';
                $orderinfo['customerEmail'] = $order['customer_email'];
                $orderinfo['discountAmount'] = $order['discount_amount'];
                //$orderinfo['firstName'] = $order['customer_firstname'];
                $orderinfo['importedAt'] = $order['created_at'];
                $orderinfo['incrementId'] = $order['increment_id'];
                //$orderinfo['lastName'] = $order['customer_lastname'];
                $orderinfo['paymentDetails'] = $payment_details;
                $orderinfo['paymentMethod'] = $payment['method'];
                $orderinfo['remoteIp'] = $order['remote_ip'];
                $orderinfo['shippingAmount'] = $order['shipping_amount'];
                $orderinfo['shippingMethod'] = $order['shipping_method'];
                $orderinfo['status'] = $order['status'];
                $orderinfo['storeName'] = 'SPOCE Project Managementspoce_project_managementSPOCE Project Management Ltd';
                $orderinfo['subtotalAmount'] = $order['subtotal'];
                $orderinfo['syncedAt'] = $order['created_at'];
                $orderinfo['taxAmount'] = $order['tax_amount'];
                $orderinfo['totalAmount'] = $order['grand_total'];
                $orderinfo['totalCanceledAmount'] = $order['total_canceled'];
                $orderinfo['totalInvoicedAmount'] = $order['total_invoiced'];
                $orderinfo['totalPaidAmount'] = $order['total_paid'];
                $orderinfo['totalRefundedAmount'] = $order['total_refunded'];
                $orderinfo['updatedAt'] = $order['updated_at'];
               
                $item_sql = "SELECT discount_amount, discount_percent, is_virtual, name, item_id, original_price, price, product_options,
	 product_type, qty_ordered, row_total, sku, tax_amount, tax_percent, row_total_incl_tax, weight FROM sales_order_item where order_id ='" . $entityId . "' ORDER BY item_id";
                $item_res = $connection->fetchAll($item_sql);
                if (!empty($item_res)) {

                    $order_items = array();
                    foreach ($item_res as $item) {
                        $order_items[] = array(
                            'discountAmount' => $item['discount_amount'],
                            'discountPercent' => $item['discount_percent'],
                            'isVirtual' => ($item['is_virtual'] == 1 ? true : false),
                            'name' => $item['name'],
                            'originId' => $item['item_id'],
                            'originalPrice' => $item['original_price'],
                            'price' => $item['price'],
                            'productOptions' => $item['product_options'],
                            'productType' => $item['product_type'],
                            'qty' => $item['qty_ordered'],
                            'rowTotal' => $item['row_total_incl_tax'],
                            'sku' => $item['sku'],
                            'taxAmount' => $item['tax_amount'],
                            'taxPercent' => $item['tax_percent'],
                            'weight' => $item['weight']);

                    }

                }
                print_r($order_items);exit;
            }
        }
        print_r($result);exit;

    }

}
