<?php
namespace Expedux\AllCronJobs\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
	public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
		$installer = $setup;

		$installer->startSetup();

        if(version_compare($context->getVersion(), '1.0.2', '<')) {
			$installer = $setup;
			$installer->startSetup();
			$connection = $installer->getConnection();
			
				$connection->addColumn(
					$installer->getTable('sales_order'),
					'oro_import',
					[
						'type' => \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
						'default' => 0,
						'length' => 11,
						'nullable' => true,
						'comment' =>'Oro Import'
					]
				);
			
		}
		$installer->endSetup();
	}
}

