<?php

namespace Expedux\CartPriceImport\Controller\Adminhtml\Import;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Controller\ResultFactory;
USE \Magento\Review\Model\Review;
use Magento\Customer\Api\GroupManagementInterface;
use Magento\SalesRule\Api\Data\ConditionInterfaceFactory;


class Upload extends \Magento\Backend\App\Action {
    /**
    * @var \Magento\Framework\View\Result\PageFactory
    */
    protected $resultPageFactory;

    protected $uploaderFactory;

    protected $varDirectory;

    protected $csvProcessor;

    protected $storeID;

    protected $product;

    protected $reviewFactory;

    protected $customerFactory;

    protected $errorArray;

    protected $reviewProductEntityId;

    protected $reviewCollectionFactory;

    protected $ratingFactory;

    protected $productCollection;
    
    protected $resource;
    
    /**
     * @var array
     */
    protected $ratings;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\MediaStorage\Model\File\UploaderFactory $uploaderFactory,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\File\Csv $csvProcessor,
        \Magento\Store\Model\StoreManager $storeManager,
        \Magento\Review\Model\ReviewFactory $reviewFactory,
        \Magento\Review\Model\ResourceModel\Review\CollectionFactory $reviewCollectionFactory,
        \Magento\Review\Model\RatingFactory $ratingFactory,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Magento\Catalog\Model\Product $productCollection,
        \Magento\Framework\ObjectManagerInterface $objectManager,
        GroupManagementInterface $groupManagement,
        \Magento\SalesRule\Model\Rule\Condition\Product $ruleConditionProduct,
        \Magento\SalesRule\Model\Rule\Condition\Product\FoundFactory $productFoundConditionFactory,
        \Magento\SalesRule\Model\Rule\Condition\ProductFactory $productConditionFactory,
        \Magento\Framework\App\ResourceConnection $resource    
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->uploaderFactory = $uploaderFactory;
        $this->varDirectory = $filesystem->getDirectoryWrite(DirectoryList::VAR_DIR); // Get default 'var' directory
        $this->csvProcessor = $csvProcessor;
        $this->storeID = $storeManager->getStore()->getId();
        $this->reviewFactory = $reviewFactory;
        $this->customerFactory = $customerFactory;
        $this->ratingFactory = $ratingFactory;
        $this->reviewCollectionFactory = $reviewCollectionFactory;
        $this->productCollection = $productCollection;
        $this->resource=$resource;
        $this->_objectManager = $objectManager;
        $this->_groupManagement = $groupManagement;
        $this->_ruleConditionProd = $ruleConditionProduct;
        $this->productFoundConditionFactory = $productFoundConditionFactory;
        $this->productConditionFactory = $productConditionFactory;
    }

    public function execute()
    {
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $resultRedirect->setPath('sales_rule/promo_quote/index');

        try{
            
            $uploader = $this->uploaderFactory->create(['fileId' => 'reviews_import_file']);
            $uploader->checkAllowedExtension('csv');
            $uploader->skipDbProcessing(true);
            $result = $uploader->save($this->getWorkingDir());
        }
        catch( \Exception $e) {
            $this->messageManager->addError( __( $e->getMessage() ) );
            return $resultRedirect;
        }

         $this->processUpload($result);

        $this->messageManager->addSuccess( __( 'Coupon imported' ) );
        
        return $resultRedirect;
    }

    public function getWorkingDir(){
        return $this->varDirectory->getAbsolutePath('importexport/');
    }

    /**
     * Process uploaded csv file
     *
     * @param [type] $result
     * @return void
     */
    public function processUpload( $result ){

        $sourceFile = $this->getWorkingDir() . $result['file'];
        
        $rows = $this->csvProcessor->getData($sourceFile);
        $header = array_shift($rows);
        $count = 0;
        $countImpt = 0;
        $countNotImpt = 0;

        $countDup = 0;
		$dupCoupons=array();
        $existCoupons=array();
        $totCoupons=array();
        //echo "<pre>";print_r($rows);exit;
         try{
        foreach ($rows as $row) {

            $data = [];
            foreach ($row as $key => $value) {
                $data[trim($header[$key])] = $value;
            }            
            if($data['status'] == 1) {
           
            $model = $this->_objectManager->create(\Magento\SalesRule\Model\Rule::class);

            $couponCheck = $model->getCollection()
            ->addFieldToFilter('code',$data['coupon_code'])
             ->load();

             if($couponCheck->getSize() > 0) {
                $existCoupons[]=$data['coupon_code'];
                $countNotImpt++;
                 continue;
             }

             
            $inputFilter = new \Zend_Filter_Input(
                [],
                [],
                $data
            );
            
            $websites = explode(',',$data['website']);
            $customerGroups = explode(',',$data['customer_group']);
            $data = $inputFilter->getUnescaped();
            $data['name'] = $data['rule_name'];
            $data['is_active'] = $data['status'];
            //$data['from_date'] = date("d/m/Y",strtotime($data['from_date']));
            //$data['to_date'] = date("d/m/Y",strtotime($data['to_date']));
            $data['from_date'] = date("Y-m-d",strtotime($data['from_date']));
            $data['to_date'] = date("Y-m-d",strtotime($data['to_date']));
            $data['uses_per_coupon'] = $data['user_per_coupon'];
            $data['simple_action'] = $data['discount_type'];
            unset($data['rule_name']);
            unset($data['status']);
            unset($data['user_per_coupon']);
            unset($data['discount_type']);
            //echo "<pre>";print_r($data);exit;
            $model->loadPost($data);
            $allGroupsId = $this->getAllCustomerGroupsId();
            if($data['customer_group'] == '999'){
                $model->setCustomerGroupIds($allGroupsId);
            }else{
                $model->setCustomerGroupIds($customerGroups);
            }
           
            if(!empty($data['product_sku'])) {
                         $actions = $this->productConditionFactory->create()
                        ->setType('Magento\SalesRule\Model\Rule\Condition\Product')
                        ->setData('attribute','sku')
                        ->setData('operator','==')
                        ->setValue($data['product_sku']);
                        $model->getActions()->addCondition($actions);
            }
            $model->setWebsiteIds($websites);
            $model->setCouponType(2);
            $model->save();

            if($model->getId()){
                $countImpt++;
            }

            $count++;

        }
        }    
    }
    catch( \Exception $e) {
        $this->messageManager->addError( __( $e->getMessage() ) );
    }

    $messageexistCoupons = '';
    $messagedupCoupons = '';
    $messagecountDup = 0;
    if(count($existCoupons) > 0) $messageexistCoupons= implode(', ',$existCoupons);
    if($countDup > 0) $messagecountDup= $countDup;
    if(count($dupCoupons) > 0) $messagedupCoupons= implode(', ',$dupCoupons);


    $message = '';
    $message .=$count.' coupon(s) total.<br />';
    $message .=$countImpt.' coupon(s) imported successfully.<br />';
    $message .=$countNotImpt.' coupon(s) were already exists. <span style="color:#F00">'.$messageexistCoupons.'</span><br />';
								
	if($messagecountDup > 0) $message .=$messagedupCoupons.' coupon(s) are duplicate in CSV. <span style="color:#F00">'.$messagedupCoupons.'</span><br />';
    
    $this->messageManager->addSuccess( __( $message ) );
    }

    protected function getAllCustomerGroupsId()
    {
        // ex: 32000
        $loggedInGroups = $this->_groupManagement->getLoggedInGroups();
         $groups = [];
         $notLoggedInGroup = $this->_groupManagement->getNotLoggedInGroup();
         $groups[] = $notLoggedInGroup->getId();
        foreach ($loggedInGroups as $group) {
            $groups[] = $group->getId();
            
        }

        return $groups;

    }
    
}