<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Expedux\Checkout\Block\Order;
use Magento\Sales\Api\Data\OrderAddressInterfaceFactory;
use Magento\Sales\Model\Order\Address;
use Magento\Framework\View\Element\Template\Context as TemplateContext;
use Magento\Framework\Registry;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Sales\Model\Order\Address\Renderer as AddressRenderer;

class Info extends \Magento\Sales\Block\Order\Info
{

    protected $_template = 'Expedux_Checkout::order/info.phtml';

    public function __construct(
        TemplateContext $context,
        Registry $registry,
        PaymentHelper $paymentHelper,
        AddressRenderer $addressRenderer,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
        OrderAddressInterfaceFactory $addressFactory,
        array $data = []
    ) {
        $this->_isScopePrivate = true;
        $this->orderAddressDelegate = $orderAddressDelegate;
        $this->addressFactory = $addressFactory;
        parent::__construct($context,$registry,$paymentHelper,$addressRenderer, $data);
    }
    

    public function getMultiDelegateShippingAddress()
    {

        $orderAddressDelegate = $this->orderAddressDelegate->create()->getCollection()
        ->addFieldToFilter('order_id', $this->getOrder()->getId());

        return $orderAddressDelegate;
    }

    public function getCustomFormatAddress($value)
    {

    $addressData = [
        'region'     => $value['region'],
        'postcode'   => $value['postcode'],
        'lastname'   => $value['lastname'],
        'street'     => $value['street'],
        'city'       => $value['city'],
        'email'      => $value['email'],
        'telephone'  => $value['telephone'],
        'country_id' => $value['country_id'],
        'firstname'  => $value['firstname'],
        'company'    => $value['company'],
        'delegate_email' => $value['delegate_email']
    ];

        $address = $this->addressFactory->create(['data' => $addressData]);
        $formattedAddress = $this->addressRenderer->format($address, 'oneline');

        return (string) $formattedAddress;

    }
}