<?php
namespace Expedux\Checkout\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\Result\RawFactory;

class SaveAddress extends Action
{

    public function __construct(
        Context $context,
        \Magento\Customer\Api\AddressRepositoryInterface $addressRepository,
        \Magento\Customer\Api\Data\AddressInterfaceFactory $addressDataFactory,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Magento\Sales\ViewModel\Customer\AddressFormatter $customerAddressFormatter,
        \Magento\Customer\Model\ResourceModel\Address\Collection $addressCollection,
        \Magento\Customer\Api\Data\RegionInterfaceFactory $regionFactory,
        \Magento\Directory\Model\RegionFactory $regFactory,
        \Magento\Customer\Model\Session $customerSession
    ) {
        $this->addressRepository = $addressRepository;
        $this->addressDataFactory = $addressDataFactory;
        $this->resultJsonFactory = $resultJsonFactory;
        $this->_customerAddressFormatter = $customerAddressFormatter;
        $this->_addressCollection = $addressCollection;
        $this->regionFactory = $regionFactory;
        $this->regFactory = $regFactory;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }

    public function execute()
    {
       // print_r('das');exit();
        $request = $this->getRequest();
        $data = $request->getParam('values');
       // echo "<pre>";

       //  print_r($addressData);exit();
        
        // $address = $this->addressDataFactory->create();
        // $address->setData($addressData['shipping_address']);
      
        // $this->addressRepository->save($address);
      //  
       // $data = $addressData['shipping_address'];
        // echo "<pre>";
        //   print_r($data);exit();

        if(isset($data['region_id'])){
            $region = $this->regFactory->create();
            $region->load($data['region_id']);
            $regionId = $region->getRegionId();
        }
        

            if(!isset($regionId)){
                $region = $this->regionFactory->create()->setRegion($data['region']);
            }

            unset($data['region']);

        
        if ($this->_customerSession->isLoggedIn()) {

        $address = $this->addressDataFactory->create(['data' => $data])->setCustomerId($this->_customerSession->getCustomerId());
        
        if(isset($regionId)){
            $address->setRegionId($regionId);
        }else{
            $address->setRegion($region);
        }
        

//echo $data['region_id'];exit();
      // $region = $this->regFactory->create()->load($data['region_id']);
    // echo $region->getCode();exit();
    //    $attributeValues['region_code'] = $region->getCode();
    //         $attributeValues['region'] = $region->getDefaultName();
           // $attributeValues['region_id'] = $data['region_id'];

   

     $address->setCustomAttribute('delegate_email', $data['custom_attributes']['delegate_email']); 

     unset($data['custom_attributes']);
     $add = $this->addressRepository->save($address);

  
     $addressArray = [];
     $addressArray = $this->_addressCollection->addFieldToFilter('entity_id', ['in' =>$add->getId()])->toArray();
   
    $addd = '';
    foreach($addressArray as $ad){
        $addd = $ad;
        $addressData = $this->addressRepository->getById($ad['entity_id']);
        if($addressData->getCustomAttribute('delegate_email')){
            $addd['delegate_email'] = $addressData->getCustomAttribute('delegate_email')->getValue();
        }
    }
        //print_r($addressArray);exit();
       $response['success'] =$this->_customerAddressFormatter->getAddressAsString($addd);
            $response['key'] =$address->getId();

}else{

  
   
   
    $data['delegate_email'] =  $data['custom_attributes']['delegate_email'];
    unset($data['custom_attributes']);
    
    $response['success'] =$this->_customerAddressFormatter->getAddressAsString($data);
    $response['key'] ='1';
}

       $result = $this->resultJsonFactory->create();
       return $result->setData($response);
    }

}