<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\Checkout\Model;
use Magento\Framework\Model\AbstractExtensibleModel;

class Address extends AbstractExtensibleModel implements \Expedux\Checkout\Api\Data\DiscountBreakdownLineInterface
{

     /**
     * @inheritdoc
     */
    public function getQty()
    {
        return $this->getData(self::KEY_QTY);
    }

    /**
     * @inheritdoc
     */
     public function setQty($qty)
    {
        return $this->setData(self::KEY_QTY, $qty);
    }

     /**
     * @inheritdoc
     */
    public function getName()
    {
        return $this->getData(self::KEY_NAME);
    }

    /**
     * @inheritdoc
     */
     public function setName($name)
    {
        return $this->setData(self::KEY_NAME, $name);
    }

     /**
     * @inheritdoc
     */
    public function getItemId()
    {
        return $this->getData(self::KEY_ITEM_ID);
    }

    /**
     * @inheritdoc
     */
     public function setItemId($itemId)
    {
        return $this->setData(self::KEY_ITEM_ID, $itemId);
    }

     /**
     * @inheritdoc
     */
    public function getProductId()
    {
        return $this->getData(self::KEY_PRODUCT_ID);
    }

    /**
     * @inheritdoc
     */
     public function setProductId($productId)
    {
        return $this->setData(self::KEY_PRODUCT_ID, $productId);
    }

}
