<?php
namespace Expedux\Checkout\Observer;

use Magento\Framework\Event\Observer;

class AfterOrder implements \Magento\Framework\Event\ObserverInterface
{

    /**
     * Execute observer
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
     public function execute(Observer $observer)
    {

        /** @var \Magento\Quote\Model\Quote $quote */
        $quote = $observer->getEvent()->getQuote();
        $order =  $observer->getEvent()->getOrder();

        if (!$quote->getId() || !$order->getId()) {
            return $this;
        }


        try {
            if ($quote->getBillingAddress()) {
                $order->getBillingAddress()->setDelegateEmail('dsadd');
            }

            if (!$quote->isVirtual()) {
                $order->getShippingAddress()->setDelegateEmail('dasd');
            }
        } catch (\Exception $e) {
            // add logger
        }
        return $this;
    }
}