<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Expedux\Checkout\Observer;

use Magento\Customer\Helper\Address as HelperAddress;
use Magento\Customer\Model\Address\AbstractAddress;
use Magento\Framework\Registry;
use Magento\Framework\Event\ObserverInterface;
use Magento\Customer\Model\Address;

/**
 * Customer Observer Model
 */
class BeforeAddressSaveObserver implements ObserverInterface
{
    /**
     * VAT ID validation currently saved address flag
     */
    const VIV_CURRENTLY_SAVED_ADDRESS = 'currently_saved_address';

    /**
     * @var HelperAddress
     */
    protected $_customerAddress;

    /**
     * @var Registry
     */
    protected $_coreRegistry;

    /**
     * @param HelperAddress $customerAddress
     * @param Registry $coreRegistry
     */
    public function __construct(
        HelperAddress $customerAddress,
        Registry $coreRegistry,
        \Magento\Framework\App\RequestInterface $request
    ) {
        $this->_customerAddress = $customerAddress;
        $this->_coreRegistry = $coreRegistry;
        $this->request = $request;
    }

    /**
     * Address before save event handler
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        /*$writer = new \Zend\Log\Writer\Stream(BP . '/var/log/amasty_landing_reindex_error.log');
                $logger = new \Zend\Log\Logger();
                $logger->addWriter($writer);
                $logger->info($observer->getCustomerAddress()->getData());
                $logger->info('dads');
                $logger->info($this->request->getParams());*/
                $customerAddress = $observer->getCustomerAddress();

              //$customerAddress->setDelegateEmail('das');
    }
}
