<?php
namespace Expedux\Checkout\Observer\Checkout;

use Magento\Customer\Api\AddressRepositoryInterface;

use Magento\Framework\Event\ObserverInterface;

class LmsAccessForExtension implements ObserverInterface
{

    public function __construct(
        AddressRepositoryInterface $addressRepository,
        \Expedux\Checkout\Model\MultishippingQuoteAddressFactory $multishippingQuoteAddress,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Magento\Customer\Model\Customer $customer,
        \Magento\Sales\Model\OrderFactory $orderFactory,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate
    ) {
        $this->multishippingQuoteAddress = $multishippingQuoteAddress;
        $this->orderAddressDelegate = $orderAddressDelegate;
        $this->addressRepository = $addressRepository;
        $this->customer = $customer;
        $this->_orderFactory = $orderFactory;
        $this->_productRepository = $productRepository;
        
    }


    public function execute(\Magento\Framework\Event\Observer $observer)
    {
     
        $order = $observer->getEvent()->getData('order');
    
        //echo $quote->getId();exit();

      //  $order->setData('is_multi_delegate', $quote->getIsMultiDelegate())->save();

      $items = $order->getAllItems();

      $data = [];

      $i=0;
		foreach ($items as $itemId => $item)
		{
  			$data[$i]['sku'] = $item->getSku();
  			$data[$i]['id'] = $item->getProductId();
			
            $prod = $this->_productRepository->getById($item->getProductId());
			$data[$i]['lms'] = $prod->getData('lms');
		}

        $product_sku=$data[0]['sku'];
		$product_id=$data[0]['id'];
		$product_lms=$data[0]['lms'];

		$customer = $this->customer->load($order->getCustomerId());
        $c_id=$order->getCustomerId();
		
		$user_id="mg_".$c_id;
		
		$partnerSalt = "2pTNRsALT!magento";
		$auth=md5($user_id.$partnerSalt);
		$type='checkUserID';
		
		 $url_checkUser="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&type=".$type;
		
		$url_checkUser = preg_replace('/\s+/', '', $url_checkUser);
		
		$curl_handle=curl_init();
		  curl_setopt($curl_handle,CURLOPT_URL,$url_checkUser);
		  curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
		  curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
		  $buffer_user = curl_exec($curl_handle);
		  curl_close($curl_handle);
		 

          		
        if($product_sku=='extension'){
			$this->processGetExtension($observer);
		}

		

        return $this;
    }

    	
	public function processGetExtension($observer) {
		
		
		$order = $observer->getEvent()->getOrder();
		$order_id=$order->getIncrementId();
		
		
		$items = $order->getAllItems();
		$data = [];
		$i=0;
		
		
		foreach ($items as $itemId => $item)
		{
  			$data[$i]['sku'] = $item->getSku();
  			$data[$i]['id'] = $item->getProductId();
			
			
			//get custom options
			$options = $item->getProductOptions(); 
			$customOptions = $options['options'];   
			if(!empty($customOptions))
			{
			  foreach ($customOptions as $option)
			  {     
				 $optionTitle = $option['label'];
				
				 if($optionTitle=='order_id')
				 {
				 	$order_id2 = $option['value'];
				 }
				 
				 if($optionTitle=='extension_days')
				 {
				 	$month = $option['value'];
				 }
				
				
			  }
			}
		}
		
		$product_sku=$data[0]['sku'];
		$product_id=$data[0]['id'];
		
		$reference_info=$order_id.'_'.$product_id;
		
		
        $order2 = $this->_orderFactory->create()->loadByIncrementId($order_id2);
		$items2 = $order2->getAllItems();
		$orderComments = $order2->getAllStatusHistory();
		$i2=0;
		$data2 = array();
		foreach ($items2 as $itemId2 => $item2)
		{ 
			$data2[$i2]['sku'] = $item2->getSku();
  			$data2[$i2]['id'] = $item2->getProductId();
			//$o_comment=$orderComments[$i2]->getComment();
			
             $prod = $this->_productRepository->getById( $item2->getProductId () );
			$data2[$i]['lms'] = $prod->getData('lms');
		}


			
			foreach ($orderComments as $key => $commentObj) 
			{
			   $getlmsstring = strpos($commentObj->getComment(), "bestpracticelms.com");		
				if ($getlmsstring !== false) {
					$o_comment_arr[] = $commentObj->getComment();
				}
 
			}

            if(count($o_comment_arr)>0)
			{
				$o_comment = $o_comment_arr[0];
			}	

		
		$product_sku2=$data2[0]['sku'];
		$product_id2=$data2[0]['id'];
		$product_lms2=$data2[0]['lms'];
		
				$customer = $this->customer->load($order->getCustomerId());
                $c_id=$order->getCustomerId();
				
				//$user_id='spoce_dev_'.$order_id2.'_'.$product_id2;
				$user_id="mg_".$c_id;
				
				
				$oc=explode("auth=", $o_comment);
				$auth=$oc[1];
				
				//$p_sku=str_replace("lms-","",$product_sku2);
				$type="getExpiry";
				
                $prod = $this->_productRepository->getById( $item2->getProductId () );
                $product_lms = $prod->getData('lms');
				
				$url="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&product=".$product_lms2."&type=".$type;
				$url = preg_replace('/\s+/', '', $url);
				
		
	
			  $curl_handle=curl_init();
			  curl_setopt($curl_handle,CURLOPT_URL,$url);
			  curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
			  curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
			  $buffer = curl_exec($curl_handle);
			  curl_close($curl_handle);
			  if (empty($buffer)){
				  $error="Error Processing LMS.";
				  $order->addStatusHistoryComment($error);
				  $order->setStatus('Canceled');
			  }
			  else{
				
				  $expiry=$buffer;
				  $success_msg="user id = ".$user_id.", auth = ".$auth.", product sku = ".$product_lms;
				  $order->addStatusHistoryComment($success_msg);
			  }

              $logger = \Magento\Framework\App\ObjectManager::getInstance()->get(\Psr\Log\LoggerInterface::class);

			if($month=='+1 Month')
			{
				$days='31 days';
			}
			else if($month=='3 Months')
			{
				$days='93 days';
			}else if($month=='6 Months')
			{
				$days='186 days';
			}
			$current_date = date("Y-m-d");
			
			if(strtotime($expiry)>strtotime($current_date))
			{
				
				$new_expiry=date('Y-m-d', strtotime($expiry."+".$days));
				
			}
			else
			{
				$new_expiry=date('Y-m-d', strtotime("+".$days));
			}
		
			$type="processExtension";
			$url_extension="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&product=".$product_lms2."&licenseExpiry=".$new_expiry."&referenceInfo=".$reference_info."&type=".$type;
			$url_extension = preg_replace('/\s+/', '', $url_extension);

			
			$curl_handle=curl_init();
			  curl_setopt($curl_handle,CURLOPT_URL,$url_extension);
			  curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
			  curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
			  $buffer_extension = curl_exec($curl_handle);
			  curl_close($curl_handle);
			  if (empty($buffer_extension)){
				  $error="Error Processing LMS.";
				  $order->addStatusHistoryComment($error);
				  $order->setStatus('Canceled');
			  }
			  else{
				   $success_msg="user id = ".$user_id.", auth = ".$auth.", product sku = ".$product_lms;
				  $order->addStatusHistoryComment($success_msg);
			  } 
			  $order->save();	
	}


}