<?php
namespace Expedux\Checkout\Observer;

use Magento\Customer\Api\AddressRepositoryInterface;

use Magento\Framework\Event\ObserverInterface;

class Order implements ObserverInterface
{


    public function __construct(
        AddressRepositoryInterface $addressRepository,
        \Magento\Framework\DataObject\Copy $objectCopyService,
        \Expedux\Checkout\Model\MultishippingQuoteAddressFactory $multishippingQuoteAddress,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate
    ) {
        $this->addressRepository = $addressRepository;
        $this->objectCopyService = $objectCopyService;
        $this->multishippingQuoteAddress = $multishippingQuoteAddress;
        $this->orderAddressDelegate = $orderAddressDelegate;
    }
   
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
     
        $order = $observer->getEvent()->getData('order');
        $orderShippingAddress = $order->getShippingAddress();
        $orderBillingAddress = $order->getBillingAddress();

        $quote = $observer->getEvent()->getData('quote');
        $quoteShippingAddress = $quote->getShippingAddress();
        // // $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/amasty_landing_reindex_error.log');
        // // $logger = new \Zend\Log\Logger();
        // // $logger->addWriter($writer);
        // // $logger->info($quote->getId());

        // //echo $quote->getId();exit();

        // $order->setData('is_multi_delegate', $quote->getIsMultiDelegate());

        // if($quoteShippingAddress->getData('customer_address_id') && $quoteShippingAddress->getData('delegate_email')){
        //     $address = $this->addressRepository->getById($quoteShippingAddress->getData('customer_address_id'));
        //     $address->setCustomAttribute('delegate_email',  $quoteShippingAddress->getDelegateEmail());
        //     $this->addressRepository->save($address);
        // }
        
        // $orderAddressDelegate = $this->orderAddressDelegate->create();

        // $multishippingQuoteAddressCollection = $this->multishippingQuoteAddress->create()->getCollection()
        // ->addFieldToFilter('quote_id', $quote->getId());

        // foreach ($multishippingQuoteAddressCollection as $key => $value) {
        //     $saveValue = [
        //         'order_id' => $order->getEntityId(),
        //         'item_id' => $value->getItemId(),
        //         'qty' => $value->getQty(),
        //         'customer_address_id' => $value->getCustomerId(),
        //         'save_in_address_book' => 0,
        //         'address_type' => 'shipping',
        //         'email' => 'email',
        //         'prefix' => $value->getPrefix(),
        //         'firstname' => $value->getFirstname(),
        //         'middlename' => $value->getMiddlename(),
        //         'lastname' => $value->getLastname(),
        //         'suffix' => $value->getSuffix(),
        //         'company' => $value->getCompany(),
        //         'street' => $value->getStreet(),
        //         'city' => $value->getCity(),
        //         'region' => $value->getRegion(),
        //         'region_id' => $value->getRegionId(),
        //         'postcode' => $value->getPostcode(),
        //         'country_id' => $value->getCountryId(),
        //         'telephone' => $value->getTelephone(),
        //         'fax' => $value->getFax(),
        //         'delegate_email' => $value->getDelegateEmail(),
                
        //     ];
        //     $orderAddressDelegate->setData($saveValue)->save();

        // }
        if($orderShippingAddress){
            $orderShippingAddress->setDelegateEmail($quoteShippingAddress->getDelegateEmail());
        }
        $orderBillingAddress->setDelegateEmail($quoteShippingAddress->getDelegateEmail());

        return $this;
    }
}