<?php

namespace Expedux\Checkout\Plugin\Checkout;

use Magento\Checkout\Block\Checkout\LayoutProcessor as LayoutProcessorCore;

class LayoutProcessor
{
    public function afterProcess(
        LayoutProcessorCore $subject,
        array  $jsLayout
    ) {
            $customAttributeCode = 'delegate_email';
            $customField = [
                'component' => 'Magento_Ui/js/form/element/abstract',
                'config' => [
                    'customScope' => 'shippingAddress.custom_attributes',
                    'customEntry' => null,
                    'template' => 'ui/form/field',
                    'elementTmpl' => 'ui/form/element/input',
                    ],
                'dataScope' => 'shippingAddress.custom_attributes' . '.' . $customAttributeCode,
                'label' => 'Delegate Email',
                'provider' => 'checkoutProvider',
                'sortOrder' => 100,
                'validation' => [
                    'required-entry' => true,
                    'validate-email' => true,
                ],
                'options' => [],
                'filterBy' => null,
                'customEntry' => null,
                'visible' => true,
            ];

            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']['shippingAddress']['children']['shipping-address-fieldset']['children'][$customAttributeCode] = $customField;

        return $jsLayout;
    }
}