<?php
namespace Expedux\Checkout\Plugin\Model;

use Psr\Log\LoggerInterface;
use Magento\Quote\Model\ShippingAddressManagement;
use Magento\Quote\Api\Data\AddressInterface;

class ShippingAddressManagementPlugin
{
    /**
     * @var LoggerInterface $logger
     */
    protected $logger;

    /**
     * ShippingAddressManagementPlugin constructor.
     * @param LoggerInterface $logger
     */
    public function __construct(
        LoggerInterface $logger,
        \Magento\Framework\DataObject\Copy $objectCopyService
    ) {
        $this->logger = $logger;
        $this->objectCopyService = $objectCopyService;
    }

    /**
     * @param ShippingAddressManagement $subject
     * @param $cartId
     * @param AddressInterface $address
     */
    public function beforeAssign(
        ShippingAddressManagement $subject,
        $cartId,
        AddressInterface $address
    ) {

        $extAttributes = $address->getExtensionAttributes();
       // if (!empty($extAttributes)) {
            try {
                $address->setDelegateEmail('dasd');

                $addressData =  $this->objectCopyService->copyFieldsetToTarget(
                    'sales_convert_quote_address',
                    'to_customer_address',
            $address,
            []
        );

                // $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/amasty_landing_reindex_error.log');
                // $logger = new \Zend\Log\Logger();
                // $logger->addWriter($writer);
                // $logger->info($addressData);

            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
            }
        //}
    }
}