<?php
namespace Expedux\Checkout\Plugin\Model;


class ShippingInformationManagement
{

    public function __construct(
        \Expedux\Checkout\Model\MultishippingQuoteAddressFactory $multishippingQuoteAddress,
        \Magento\Quote\Model\QuoteRepository $quoteRepository,
        \Magento\Customer\Model\Session $customerSession
    ) {
        $this->multishippingQuoteAddress = $multishippingQuoteAddress;
        $this->quoteRepository = $quoteRepository;
        $this->_customerSession = $customerSession;

    }

  public function beforeSaveAddressInformation(
        \Magento\Checkout\Model\ShippingInformationManagement $subject,
        $cartId,
        \Magento\Checkout\Api\Data\ShippingInformationInterface $addressInformation
    )
    {
        
      
        $shippingAddress = $addressInformation->getShippingAddress();

        $multishippingAddress = $this->multishippingQuoteAddress->create();
        $quote = $this->quoteRepository->getActive($cartId);
        if($this->_customerSession->getMultiDelegate()){
            
            $quote->setIsMultiDelegate(1);
        
        // foreach ($addressInformation->getExtensionAttributes()->getMultishippingItems() as $key => $value) {
        //     echo $value->getName(); exit();
        // }
      $itemsArray = $addressInformation->getExtensionAttributes()->getMultishippingItems();
    //    ($addressInformation->getExtensionAttributes()->getMultishippingItems());exit();
        foreach ($addressInformation->getExtensionAttributes()->getMultishippingAddress() as $key => $value) {
         
         if(is_numeric($key) && isset($itemsArray[$key])){
            $items = $itemsArray[$key];
            $extensionAttributes = $value->getExtensionAttributes();
           
           $saveValue = [
            'quote_id' => $cartId,
            'item_id' => $items['item_id'],
            'qty' => $items['qty'],
            'product_id' => $items['product_id'],
            'customer_id' => $value->getCustomerAddressId(),
            'save_in_address_book' => 0,
            'address_type' => 'shipping',
            'email' => 'email',
            'prefix' => $value->getPrefix(),
            'firstname' => $value->getFirstname(),
            'middlename' => $value->getMiddlename(),
            'lastname' => $value->getLastname(),
            'suffix' => $value->getSuffix(),
            'company' => $value->getCompany(),
            'street' => implode("\n", $value->getStreet()),
            'city' => $value->getCity(),
            'region' => $value->getRegion(),
            'region_id' => $value->getRegionId(),
            'postcode' => $value->getPostcode(),
            'country_id' => $value->getCountryId(),
            'telephone' => $value->getTelephone(),
            'fax' => $value->getFax(),
            'delegate_email' => $extensionAttributes->getDelegateEmail(),
            'item_key' => $key
            
        ];
      
        $multishippingQuoteAddressCollection = $this->multishippingQuoteAddress->create()->getCollection()
        ->addFieldToFilter('quote_id', $cartId)
        ->addFieldToFilter('item_key', $key)                         
        ->addFieldToFilter('item_id', $items['item_id'])->getFirstItem();

        if($multishippingQuoteAddressCollection->getAddressId())
        {
           
            $saveValue['address_id'] = $multishippingQuoteAddressCollection->getAddressId();
            
        }

       
        $multishippingAddress->setData($saveValue)->save();

        }
        
      }

    }else{
        $quote->setIsMultiDelegate(0);
    }
        $shippingAddressExtensionAttributes = $shippingAddress->getExtensionAttributes();
        if ($shippingAddressExtensionAttributes) {
            //echo $shippingAddressExtensionAttributes->getDelegateEmail();exit();
            $shippingAddress->setDelegateEmail($shippingAddressExtensionAttributes->getDelegateEmail());
            $shippingAddressExtensionAttributes->setDelegateEmail($shippingAddressExtensionAttributes->getDelegateEmail());
           }
        
    }
}
