<?php


namespace Expedux\Checkout\Setup;

use Magento\Customer\Model\Customer;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Customer\Setup\CustomerSetupFactory;

class UpgradeData implements UpgradeDataInterface
{

    private $customerSetupFactory;

    public function __construct(
        CustomerSetupFactory $customerSetupFactory
    ) {
        $this->customerSetupFactory = $customerSetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context){

        $setup->startSetup();

        $customerSetup = $this->customerSetupFactory->create(['setup' => $setup]);

        $customerEntityTypeCode = 'customer';
        $customerAddrEntityTypeCode = 'customer_address';

        if (version_compare($context->getVersion(), '1.0.3') < 0) {

        $attributeCodeCusDelEmail = "delegate_email";
        $customerSetup->removeAttribute($customerAddrEntityTypeCode, $attributeCodeCusDelEmail);          
        $customerSetup->addAttribute($customerAddrEntityTypeCode,
            $attributeCodeCusDelEmail, [
            'type' => 'varchar',
            'input' => 'text',
            'label' => 'Delegate Email',
            'visible' => true,
            'required' => true,
            'user_defined' => true,
            'system'=> false,
            'group'=> 'General',
            'global' => true,
            'visible_on_front' => true,
            'position' => 157,
            ]);
        $cusDelEmailAttribute = $customerSetup->getEavConfig()->getAttribute($customerAddrEntityTypeCode, $attributeCodeCusDelEmail);
        $cusDelEmailAttribute->setData('used_in_forms', ['adminhtml_customer_address','customer_address_edit','customer_register_address']);
        $cusDelEmailAttribute->save();

      }


      if (version_compare($context->getVersion(), '1.0.14') < 0) {

        $customerSetup->addAttribute(
            $customerEntityTypeCode,
             'mobile_number', 
             [
            'label' => 'Mobile/Telephone',
            'required' => true,
            'visible' => true,
            'sort_order' => 155,
            'position' => 155,
            'type' => 'text',
            'frontend_input' => 'text',
            'system'=> 0,
            
        ]);

        $mobileAttribute = $customerSetup->getEavConfig()->getAttribute('customer', 'mobile_number');
        $mobileAttribute->setData('used_in_forms',['adminhtml_customer' ,'customer_account_create','customer_account_edit']);
        $mobileAttribute->save();

     }
     if (version_compare($context->getVersion(), '1.0.15') < 0) {
         
        //$customerSetup->removeAttribute($customerEntityTypeCode, 'hear_about_us');  
        
        //$customerSetup->removeAttribute($customerEntityTypeCode, 'job_title_position'); 


        $hearaboutusAttribute = $customerSetup->getEavConfig()->getAttribute('customer', 'referall');
        $hearaboutusAttribute->setData('used_in_forms',['adminhtml_customer' ,'customer_account_create']);
        $hearaboutusAttribute->save();
       

        $jobTitlePositionAttribute = $customerSetup->getEavConfig()->getAttribute('customer', 'jobtitle');
        $jobTitlePositionAttribute->setData('used_in_forms',['adminhtml_customer' ,'customer_account_create','customer_account_edit']);
        $jobTitlePositionAttribute->save();

        $interestedinAttribute = $customerSetup->getEavConfig()->getAttribute('customer', 'interested_in');
        $interestedinAttribute->setData('used_in_forms',['adminhtml_customer' ,'customer_account_create']);
        $interestedinAttribute->save();


        $companyAttribute = $customerSetup->getEavConfig()->getAttribute('customer', 'company_name');
        $companyAttribute->setData('used_in_forms',['adminhtml_customer' ,'customer_account_create','customer_account_edit']);
        $companyAttribute->save();

        $preferencesAttribute = $customerSetup->getEavConfig()->getAttribute('customer', 'marketing_preferences');
        $preferencesAttribute->setData('used_in_forms',['adminhtml_customer' ,'customer_account_create','customer_account_edit']);
        $preferencesAttribute->save();

     }

     if (version_compare($context->getVersion(), '1.0.16') < 0) {
        
        $customerSetup->updateAttribute(
            $customerEntityTypeCode,
            'mobile_number',
            'is_required',
            false
          );

        }

       /* if (version_compare($context->getVersion(), '1.0.18') < 0) {
        
            $customerSetup->addAttribute(
                $customerEntityTypeCode,
                "referall",
                [
                    'type' => 'int',
                    'label' => 'How did you hear about us?',
                    'input' => 'select',
                    'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Table',
                    'required' => false,
                    'sort_order' => 150,
                    'visible' => true,
                    'position' => 150,
                    'admin_checkout' => 1,
                    'option' => ['values' => ['Editorial', 'Email', 'Exhibition', 
                    'Magazine Ad','Newspaper Ad','Returning Customer','Social Media','Web Search','Word of Mouth']],
                    'system' => 0,
                ]
            );

            $customerSetup->addAttribute(
                $customerEntityTypeCode,
                "marketing_preferences",
                [
                    'type' => 'text',
                    'label' => 'Other Marketing Preferences',
                    'input' => 'multiselect',
                    'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Table',
                    'required' => false,
                    'sort_order' => 150,
                    'visible' => true,
                    'position' => 150,
                    'admin_checkout' => 1,
                    'option' => ['values' => ['Telephone', 'Email', 'SMS/Text']],
                    'system' => 0,
                ]
            );

        }*/


        $setup->endSetup();
    }
}