<?php
namespace Expedux\Checkout\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UpgradeSchemaInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{

    /**
     * {@inheritdoc}
     */
    public function upgrade(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $installer = $setup;

        $installer->startSetup();



        if (version_compare($context->getVersion(), '1.0.1', '<')) {

            $eavTable1 = $installer->getTable('sales_order_address');
    
            $columns = [
                'delegate_email' => [
                    'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                    'nullable' => true,
                    'default' => NULL,
                    'length' => 255,
                    'comment' => 'Delegate Email'
                ]
            ];
    
            $connection = $installer->getConnection();
    
            foreach($columns as $name => $definition) {
                $connection->addColumn($eavTable1, $name, $definition);
            }



            $eavTable2 = $installer->getTable('quote_address');
    
            $columns = [
                'delegate_email' => [
                    'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                    'nullable' => true,
                    'default' => NULL,
                    'length' => 255,
                    'comment' => 'Delegate Email'
                ]
            ];
    
            $connection = $installer->getConnection();
    
            foreach($columns as $name => $definition) {
                $connection->addColumn($eavTable2, $name, $definition);
            }

        }

        if (version_compare($context->getVersion(), '1.0.6', '<')) {
            $setup->getConnection()->dropTable($setup->getTable('multishipping_quote_address'));
            $table = $setup->getConnection()->newTable(
                $setup->getTable('multishipping_quote_address')
            )->addColumn(
                'address_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                null,
                ['identity' => true,'nullable' => false, 'primary' => true],
                'Address ID'
            )->addColumn(
                'quote_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false],
                'Quote ID'
            )->addColumn(
                'item_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false],
                'Item ID'
            )->addColumn(
                'qty',
                \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                '12,4',
                ['nullable' => false, 'default' => '0.0000'],
                'Qty'
            )->addColumn(
                'created_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                'Created At'
            )->addColumn(
                'updated_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false,'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
                'Updated At'
            )->addColumn(
                'customer_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => true],
                'Customer ID'
            )->addColumn(
                'save_in_address_book',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                6,
                ['nullable' => true],
                'Save In Address Book'
            )->addColumn(
                'address_type',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                10,
                ['nullable' => true],
                'Address Type'
            )->addColumn(
                'email',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Email'
            )->addColumn(
                'prefix',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Prefix'
            )->addColumn(
                'firstname',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Firstname'
            )->addColumn(
                'middlename',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                40,
                ['nullable' => true],
                'Middle Name'
            )->addColumn(
                'lastname',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Lastname'
            )->addColumn(
                'suffix',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                40,
                ['nullable' => true],
                'Suffix'
            )->addColumn(
                'company',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Company'
            )->addColumn(
                'street',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Street'
            )->addColumn(
                'city',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'City'
            )->addColumn(
                'region',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Region'
            )->addColumn(
                'region_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => true],
                'Region ID'
            )->addColumn(
                'postcode',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                20,
                ['nullable' => true],
                'Postcode'
            )->addColumn(
                'country_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                30,
                ['nullable' => true],
                'Country ID'
            )->addColumn(
                'telephone',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'telephone'
            )->addColumn(
                'fax',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'fax'
            )->addColumn(
                'delegate_email',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Delegate Email'
            )->setComment(
                'Sales Flat Quote Address'
            );
            $setup->getConnection()->createTable($table);
            }

      

        if (version_compare($context->getVersion(), '1.0.7', '<')) {
            $setup->getConnection()->dropTable($setup->getTable('sales_flat_order_address_delegate'));
            $table = $setup->getConnection()->newTable(
                $setup->getTable('sales_flat_order_address_delegate')
            )->addColumn(
                'entity_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                null,
                ['identity' => true,'nullable' => false, 'primary' => true],
                'Entity Id'
            )->addColumn(
                'customer_address_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false],
                'Customer Address Id'
            )->addColumn(
                'customer_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false],
                'Customer Id'
            )->addColumn(
                'order_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false],
                'Order Id'
            )->addColumn(
                'item_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => false],
                'Item ID'
            )->addColumn(
                'qty',
                \Magento\Framework\DB\Ddl\Table::TYPE_DECIMAL,
                '12,4',
                ['nullable' => false, 'default' => '0.0000'],
                'Qty'
            )->addColumn(
                'created_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
                'Created At'
            )->addColumn(
                'updated_at',
                \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
                null,
                ['nullable' => false,'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
                'Updated At'
            )->addColumn(
                'customer_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => true],
                'Customer ID'
            )->addColumn(
                'save_in_address_book',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                6,
                ['nullable' => true],
                'Save In Address Book'
            )->addColumn(
                'address_type',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                10,
                ['nullable' => true],
                'Address Type'
            )->addColumn(
                'email',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Email'
            )->addColumn(
                'prefix',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Prefix'
            )->addColumn(
                'firstname',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Firstname'
            )->addColumn(
                'middlename',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                40,
                ['nullable' => true],
                'Middle Name'
            )->addColumn(
                'lastname',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Lastname'
            )->addColumn(
                'suffix',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                40,
                ['nullable' => true],
                'Suffix'
            )->addColumn(
                'company',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Company'
            )->addColumn(
                'street',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Street'
            )->addColumn(
                'city',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'City'
            )->addColumn(
                'region',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Region'
            )->addColumn(
                'region_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
                10,
                ['nullable' => true],
                'Region ID'
            )->addColumn(
                'postcode',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                20,
                ['nullable' => true],
                'Postcode'
            )->addColumn(
                'country_id',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                30,
                ['nullable' => true],
                'Country ID'
            )->addColumn(
                'telephone',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'telephone'
            )->addColumn(
                'fax',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'fax'
            )->addColumn(
                'delegate_email',
                \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                255,
                ['nullable' => true],
                'Delegate Email'
            )->setComment(
                'Sales Flat Quote Address'
            );
            $setup->getConnection()->createTable($table);
            }

          
    
    
            if (version_compare($context->getVersion(), '1.0.8', '<')) {
    
                $eavTable1 = $installer->getTable('multishipping_quote_address');
        
                $columns = [
                    'item_key' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 255,
                        'after' => 'item_id',
                        'comment' => 'Item Key'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable1, $name, $definition);
                }
    
            }


            if (version_compare($context->getVersion(), '1.0.9', '<')) {
    
                $eavTable1 = $installer->getTable('sales_flat_order_address_delegate');
        
                $columns = [
                    'order_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 10,
                        'after' => 'entity_id',
                        'comment' => 'Order Id'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable1, $name, $definition);
                }
    
            }

            if (version_compare($context->getVersion(), '1.0.10', '<')) {


                $installer->getConnection()->changeColumn(
                    $installer->getTable('multishipping_quote_address'),
                    'street',
                    'street',
                    ['type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 'nullable' => true,'comment' => 'Street']
                );
    
                $installer->getConnection()->changeColumn(
                    $installer->getTable('sales_flat_order_address_delegate'),
                    'street',
                    'street',
                    ['type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT, 'nullable' => true,'comment' => 'Street']
                );
    
    
    
            }

            if (version_compare($context->getVersion(), '1.0.11', '<')) {


                $eavTable1 = $installer->getTable('sales_flat_order_address_delegate');
        
                $columns = [
                    'product_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 10,
                        'after' => 'item_id',
                        'comment' => 'Product Id'
                    ],
                    'comment' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => '2M',
                        'after' => 'delegate_email',
                        'comment' => 'Comment'
                    ],
                    'lms_delegate_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'after' => 'comment',
                        'comment' => 'Lms Delegate Id'
                    ],
                    'vat_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 255,
                        'after' => 'lms_delegate_id',
                        'comment' => 'Vat Id'
                    ],
                    'is_join_send' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'after' => 'vat_id',
                        'comment' => 'Is Join Send'
                    ],
                    'delegate_special_req' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 10,
                        'after' => 'is_join_send',
                        'comment' => 'Delegate Special Reg'
                    ],
                    'lms_access' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 10,
                        'after' => 'delegate_special_req',
                        'comment' => 'Lms Access'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable1, $name, $definition);
                }


                $eavTable2 = $installer->getTable('sales_order');
        
                $columns = [
                    'lms_access' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'comment' => 'Lms Access'
                    ],
                    'lms_delegate_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'comment' => 'Lms Delegate Id'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable2, $name, $definition);
                }

            }

            if (version_compare($context->getVersion(), '1.0.12', '<')) {

                $eavTable2 = $installer->getTable('sales_order_item');
        
                $columns = [
                    'lms_access' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'comment' => 'Lms Access'
                    ],
                    'lms_delegate_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'comment' => 'Lms Delegate Id'
                    ],
                    'lms_comment' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'comment' => 'Lms Comment'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable2, $name, $definition);
                }
            }

            if (version_compare($context->getVersion(), '1.0.13', '<')) {
              
                $eavTable2 = $installer->getTable('multishipping_quote_address');
        
                $columns = [
                    'product_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'after' => 'item_id',
                        'comment' => 'Product Id'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable2, $name, $definition);
                }


            }

            if (version_compare($context->getVersion(), '1.0.17', '<')) {

                $salesOrder = $installer->getTable('sales_order');
        
                $columns = [
                    'admin_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'after' => 'lms_delegate_id',
                        'comment' => 'Admin Id'
                    ],
                    'admin_username' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 255,
                        'after' => 'admin_id',
                        'comment' => 'Admin Username'
                    ],
                    'admin_name' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 255,
                        'after' => 'admin_username',
                        'comment' => 'Admin Name'
                    ],
                    'delegate_special_req' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_TEXT,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => '2M',
                        'after' => 'admin_name',
                        'comment' => 'Delegate Special Req'
                    ],
                    'pushalert' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_BOOLEAN,
                        'nullable' => false,
                        'default' => '0',
                        'after' => 'delegate_special_req',
                        'comment' => 'Pushalert'
                    ],
                    'review_request' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_BOOLEAN,
                        'nullable' => false,
                        'default' => '0',
                        'after' => 'pushalert',
                        'comment' => 'Review Request'
                    ],
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($salesOrder, $name, $definition);
                }


            }

            if (version_compare($context->getVersion(), '1.0.20', '<')) {
              
                $eavTable2 = $installer->getTable('multishipping_quote_address');
        
                $columns = [
                    'customer_address_id' => [
                        'type' => \Magento\Framework\DB\Ddl\Table ::TYPE_INTEGER,
                        'nullable' => true,
                        'default' => NULL,
                        'length' => 11,
                        'after' => 'customer_id',
                        'comment' => 'Customer Address Id'
                    ]
                ];
        
                $connection = $installer->getConnection();
        
                foreach($columns as $name => $definition) {
                    $connection->addColumn($eavTable2, $name, $definition);
                }


            }
    
            $installer->endSetup();
    }

}