define(
    [
        'jquery',
        'ko',
        'underscore',
        'Magento_Checkout/js/action/create-shipping-address',
        'Magento_Customer/js/model/customer',
        'Expedux_Checkout/js/model/storage',
        'Expedux_Checkout/js/model/exquote',
        'Expedux_Checkout/js/model/storagemulti'
    ], function (
        $,
        ko,
        _,
        createShippingAddress,
        customer,
        expeduxstorage,
        exquote,
        storagemulti
    ) {
        'use strict';

        return function (target) {
            return target.extend({

                defaults: {
                    template: 'Expedux_Checkout/shipping',
                    links: {
                        isAddressFormVisible: '${$.shipAddressListProvider}:isNewAddressSelected'
                    }
                },
                multidelegate: window.checkoutConfig.show_multidelegate,
                storagemulti: ko.observable(null),

                /**
         * @return {exports.initObservable}
         */
        initObservable: function () {
            this._super()
                .observe({
                   
                    isAddressFormVisible: true,
                   
                });
                return this;
            },
            
                setShippingInformation: function () {
                    console.log(exquote.multishippingAddress())

                    var addressData,
                    newShippingAddress;

                   
                    if (this.validateCardMessage()) {
                        var self = this
                        _.each(exquote.multishippingAddress(), function (component, index) {
                            console.log(component)

                            if(component.customerAddressId == null){
                                console.log('dd')
                                addressData = self.source.get('shippingAddress');
                                newShippingAddress = createShippingAddress(addressData);
                                exquote.multishippingAddress()[index] = newShippingAddress
                            }

                            var shippingAddress = exquote.multishippingAddress()[index];
                            if (shippingAddress['extension_attributes'] === undefined) {
                                shippingAddress['extension_attributes'] = {};
                            }
                
                            if (shippingAddress.customAttributes != undefined) {
                                $.each(shippingAddress.customAttributes , function( key, value ) {
                                     shippingAddress['extension_attributes'][value.attribute_code] = value.value;
                                });
                            }

                           });
                        this._super();
                    }
                    
                },

                validateCardMessage: function() {
                    if (this.isAddressFormVisible()) {
                        this.source.set('params.invalid', false);
                        this.triggerShippingDataValidateEvent();
                   
                    if (this.source.get('params.invalid')) {
                        return false;
                    }

                    return true;

                 }

                 return true;

                },

                saveAddress:function(){
                    // console.log(window);
                    var addressData,
                    newShippingAddress;
                   // this.isAddressFormVisible(false)
                    console.log(customer)
                    console.log(expeduxstorage.addressSelectId())
                    addressData = this.source.get('shippingAddress')
                    var self = this
                    if (this.validateCardMessage()) {
                     $.ajax({
                         url: '/expeduxcheckout/index/saveaddress',
                         type: 'post',
                         dataType: 'json',
                         showLoader: true,
                         data: { values: addressData},
                         }).done(function (response) {
                             console.log(response)
                             console.log(expeduxstorage.addressSelectId())
                             console.log(storagemulti())

                             var select = $('#'+expeduxstorage.addressSelectId());

                             addressData = self.source.get('shippingAddress');
                             newShippingAddress = createShippingAddress(addressData);
                             newShippingAddress.customerAddressId = 0;
                             console.log(select)
                             if(expeduxstorage.addressSelectId()){

                             
                             console.log(select)
                             console.log(exquote)
                             var $option;
                             var newoption = select.find('option:selected');

                             select.find('option:selected').remove();
                             newoption.removeAttr("selected");
                                
                                $option = $('<option value="'+ exquote.customAddress().length +'">'+ response.success +'</option>');
                                $option.attr('selected', 'selected').change();

                                select.append($option);

                                select.append(newoption);

                                exquote.multishippingAddress()[$(select).attr("data-id")] = newShippingAddress

                            }else{
                                $(".multidelegateddress").each(function(index){
                                    var $option;
                                    var newoption = $(this).find('option:selected');
                                    newoption.removeAttr("selected");

                                    $option= $('<option value="'+ exquote.customAddress().length +'">'+ response.success +'</option>'); 
                                    $option.attr('selected', 'selected').change();

                                    $(this).append($option);

                                    $(this).append(newoption);
                                    
                                    console.log($(this));

                                    exquote.multishippingAddress()[$(this).attr("data-id")] = newShippingAddress

                                });


                            }
                            
                             
                             console.log(newShippingAddress)
                             exquote.customAddress.push(newShippingAddress)
                                
                             console.log(exquote.customAddress().length)
                             console.log($(exquote.customAddress()[0]).get(-1))
                             self.isAddressFormVisible(false)

                            
                             //window.location.href = window.checkout.shoppingCartUrl;
                         }).fail(function (error) {
                         console.log(JSON.stringify(error));
                     });
                    }
                 },
              
            });
        }
    }
);
