/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'underscore',
    'uiComponent',
    'Magento_Customer/js/model/address-list',
    'mage/translate',
    'Magento_Customer/js/model/customer',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Expedux_Checkout/js/model/exquote',
    'Expedux_Checkout/js/model/storage',
    'Expedux_Checkout/js/model/storagemulti'
], function ($,_,Component, addressList, $t, customer,quote,checkoutData,exquote,expeduxstorage,storagemulti) {
    'use strict';

    var newAddressOption = {
            /**
             * Get new address label
             * @returns {String}
             */
            getAddressInline: function () {
                return $t('New Address');
            },
            customerAddressId: null
        },
        addressOptions = addressList().filter(function (address) {
            return address.getType() === 'customer-address';
        });

    return Component.extend({
        defaults: {
            template: 'Expedux_Checkout/multishipping-address',
            multishippingListTemplate: 'Expedux_Checkout/multishipping-address/list',
            selectedAddress: {},
            multishippingAddress: [],
            isNewAddressSelected: true,
            addressOptions: addressOptions,
            quoteItems: [],
            exports: {
                selectedAddress: '${ $.parentName }:selectedAddress'
            }
        },

        /**
         * @returns {Object} Chainable.
         */
        initConfig: function () {
            this._super();
           
            this.addressOptions.push(newAddressOption);
            var self = this
            console.log(quote.getItems())
            _.each(quote.getItems(), function (component, index) {
                var item = [];
                for (let i = 0; i < component.qty; ++i) {
                    item = {'qty':1,'name':component.product.name,'product_id':component.product_id,'item_id':component.item_id}
                    self.quoteItems.push(item)
                }
              });
             exquote.multishippingItems(this.quoteItems)
            return this;
            
        },

        /**
         * @return {exports.initObservable}
         */
        initObservable: function () {
            this._super()
                .observe('selectedAddress isNewAddressSelected')
                .observe({
                    isNewAddressSelected: !customer.isLoggedIn() || !addressOptions.length
                });

            return this;
        },
        
        /**
         * @param {Object} address
         * @return {*}
         */
        addressOptionsText: function (address) {
            return address.getAddressInline();
        },

        /**
         * @param {Object} address
         */
        onAddressChange: function (address,id) {
            console.log(address)
            console.log(this.selectedAddress)
            
            exquote.multishippingAddress(address)
            console.log(exquote.multishippingAddress())
            var self =this
            var value = false
            _.each(address, function (component, index) {
                console.log(typeof component)
                if(component === newAddressOption){
                    value = true;
                    return false;
                }
                if(typeof component == "string" ){
                    console.log(exquote.customAddress()[component])
                    console.log(index)
                    console.log(component)
                    exquote.multishippingAddress()[index] = exquote.customAddress()[component]
                }
               });
              this.isNewAddressSelected(value)
             
            //   $(".multidelegateddress").each(function(index){
            //         if(index == 0){
            //             expeduxstorage.addressSelectId($(this).attr("id"))   
            //         }
            //    });
             
              console.log(exquote.multishippingAddress())
        },

        onClick: function(data, event){
        console.log(event)
        console.log(event.target.id)
            if(event.target.id){
                expeduxstorage.addressSelectId(event.target.id)    
            }
          
        },

        
    });
});
