<?php

namespace Expedux\CouponsUsage\Block\Adminhtml\CouponsUsage;

class Grid extends \Magento\Backend\Block\Widget\Grid\Extended
{

    public $collectionFactory;
    public $inquiry;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Helper\Data $backendHelper,
        \Magento\Sales\Model\ResourceModel\Order\CollectionFactory $collectionFactory,
        array $data = []
    ) {
        $this->collectionFactory = $collectionFactory;
        parent::__construct($context, $backendHelper, $data);
    }

    public function _construct()
    {
        parent::_construct();
        $this->setId('inquiryGrid');
        $this->setDefaultSort('inquiry_id');
        $this->setDefaultDir('DESC');
        $this->setUseAjax(false);
        $this->setSaveParametersInSession(true);
    }

    public function _prepareCollection()
    {
        $collection = $this->collectionFactory->create();

        $collection->addAttributeToFilter('coupon_code', array('notnull' => TRUE));
        $collection->addAttributeToFilter('coupon_code', array('neq' => ''));

        $collection->getSelect()
        ->joinLeft(array('salesrule_coupon' => 'salesrule_coupon'), 'main_table.coupon_code = salesrule_coupon.code',
            ['code',
            'rule_id'
            ]
        )->joinLeft(
            ['salesrule' => 'salesrule'],
            'salesrule_coupon.rule_id = salesrule.rule_id',
            [
            'name'
            ]
        )->joinLeft(
            ["sfoad" => "sales_flat_order_address_delegate"],
            'main_table.entity_id = sfoad.order_id',
            ['telephone AS d_telephone',
            'delegate_email AS d_company']
        )->group('main_table.entity_id');

        $collection->join(
            ["soa" => "sales_order_address"],
            'main_table.entity_id = soa.parent_id AND soa.address_type="shipping"',
            ['delegate_email', 'telephone','company']
        );


        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    public function _prepareColumns()
    {
        
        
        $this->addColumn('coupon_code', ['header' => __('Coupon Code'), 'index' => 'coupon_code']);
        $this->addColumn('name', 
        [
            'header' => __('Rule Name'), 
            'index' => 'name',
            'renderer' => $this->_isExport ? '' : \Expedux\CouponsUsage\Block\Adminhtml\CouponsUsage\Grid\Renderer\Rule::class,
            ]
        );
        
        $this->addColumn(
            'increment_id',
            [
            'header'    => __('Order #'),
            'index'     => 'increment_id',
            'renderer' => $this->_isExport ? '' : \Expedux\CouponsUsage\Block\Adminhtml\CouponsUsage\Grid\Renderer\IncrementId::class,
            ]
        );

        $this->addColumn('created_at', ['header' => __('Purchased On'), 'index' => 'created_at']);
        $this->addColumn('grand_total', ['header' => __('G.T. (Purchased)'), 'index' => 'grand_total']);
        $this->addColumn('status', ['header' => __('Status'), 'index' => 'status']);
     

        $this->addColumn(
            'telephone',
            [
                'header' => __('Telephone'),
                'index' => 'd_telephone',
                'renderer' => '\Expedux\CouponsUsage\Block\Adminhtml\CouponsUsage\Grid\Renderer\Telephone','filter_condition_callback' => [$this, '_filterTelCollection'],
                'sortable' => false,
            ]
        );
        
           
               $this->addColumn(
                'email',
                [
                    'header' => __('Email'),
                    'index' => 'd_company',
                    'renderer' => '\Expedux\CouponsUsage\Block\Adminhtml\CouponsUsage\Grid\Renderer\Email','filter_condition_callback' => [$this, '_filterEmailCollection'],
                    'sortable' => false,
                ]
            );
        

        $this->addExportType('*/*/exportCsv', __('CSV'));
        $this->addExportType('*/*/exportXml', __('XML'));

        return parent::_prepareColumns();
    }

    public function getGridUrl()
    {
        return $this->getUrl('*/*/index', ['_current' => true]);
    }

    protected function _filterTelCollection($collection, $column)
{

    if (!$value = $column->getFilter()->getValue()) {
        return;
    }

    $value = trim($column->getFilter()->getValue());

    $this->getCollection()->addFieldToFilter(array('sfoad.telephone', 'soa.telephone'), [$value,$value]);
    return $this;
}

protected function _filterEmailCollection($collection, $column)
{
    if (!$value = $column->getFilter()->getValue()) {
        return;
    }

    $value = trim($column->getFilter()->getValue());
    // $this->getCollection()->getSelect()->where(
    //     // do filter 
    // );
    $this->getCollection()->addFieldToFilter(array('sfoad.delegate_email', 'soa.delegate_email','main_table.customer_email'), [$value,$value,$value]);
    return $this;
}
}
