<?php

namespace Expedux\Customerdoc\Block\Adminhtml\Document\Edit;

class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Expedux\Customerdoc\Model\Status $options,
        \Expedux\Customerdoc\Model\Category $categoryoptions,
        \Magento\Customer\Model\ResourceModel\Group\Collection $customerGroup,
        array $data = []
    ) {
        $this->_options = $options;
        $this->_categoryoptions = $categoryoptions;
        $this->_customerGroup = $customerGroup; 
        parent::__construct($context, $registry, $formFactory, $data);
    }


    protected function _prepareForm()
    {
        $attachment = $this->getAttachment();
        
        // if (!$attachment->getId()) {
        //         $attachment->addData($attachment->getDefaultValues());
        // }
       
        #$attachment->setAssignType(AssignTypeOptions::ASSIGN_BY_GRID);
        $model = $this->_coreRegistry->registry('row_data');
        $form = $this->_formFactory->create(
            ['data' => [
                            'id' => 'edit_form',
                            'enctype' => 'multipart/form-data',
                            'action' => $this->getData('action'),
                            'method' => 'post'
                        ]
            ]
        );
        #$form->setHtmlIdPrefix('zipcode_');
        if ($model->getId()) {
        
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Edit Document'), 'class' => 'fieldset-wide']
            );
            $fieldset->addField('document_id', 'hidden', ['name' => 'document_id']);
            
        } else {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Add Document'), 'class' => 'fieldset-wide']
            );
        }
       

        $fieldset->addField(
            'document_name',
            'text',
            [
                'name' => 'document_name',
                'label' => __('File Name'),
                'id' => 'document_name',
                'title' => __('document_name'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'document_description',
            'textarea',
            [
                'name' => 'document_description',
                'label' => __('File Description'),
                'id' => 'document_description',
                'title' => __('document_description'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addType('file', 'Expedux\Customerdoc\Block\Adminhtml\Helper\File');
        $fieldset->addField(
            'file_path',
            'file',
            [
                'name' => 'file_path',
                'label' => __('File Upload'),
                'id' => 'file_path',
                'index' => 'file_path',
                'title' => __('file_path'),
                'class' => '',
                'required' => false,
            ]
        );
    
        $fieldset->addField(
            'created_at',
            'date',
            [
                'name' => 'created_at',
                'label' => __('Created Time'),
                'id' => 'created_at',
                'title' => __('created_at'),
                'class' => 'required-entry',
                'required' => true,
                'date_format' => 'yyyy-MM-dd',
                #'time_format' => 'hh:mm:ss',
            ]
        );
   

        $fieldset->addField(
            'status',
            'select',
            [
                'name' => 'status',
                'label' => __('Status'),
                'id' => 'status',
                'title' => __('Status'),
                'values' => $this->_options->getOptionArray(),
                'class' => 'status',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'send_mail',
            'select',
            [
                'name' => 'send_mail',
                'label' => __('Send Mail'),
                'id' => 'send_mail',
                'title' => __('send_mail'),
                'class' => 'required-entry',
                'value'  => '1',
                'values' => array('1' => 'Yes','2' => 'No'),
                'required' => true,
            ]
        );
        $fieldset->addField(
            'customer_category',
            'select',
            [
                'name' => 'customer_category',
                'label' => __('Category'),
                'id' => 'customer_category',
                'title' => __('customer_category'),
                'class' => 'required-entry',
                'values' => $this->_categoryoptions->getAllOptions(),
                'required' => true,
            ]
        );
        $fieldset->addField(
            'customer_group',
            'multiselect',
            [
                'name' => 'customer_groups[]',
                'label' => __('Group'),
                'id' => 'customer_group',
                'title' => __('customer_group'),
                'class' => 'required-entry',
                'values' => $this->getCustomerGroups(),
                'required' => true,
            ]
        );
        $form->setValues($model->getData());
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
    /**
     * Get customer groups
     * 
     * @return array
     */ 
    public function getCustomerGroups() {
        $customerGroups = $this->_customerGroup->toOptionArray();
        array_unshift($customerGroups, array('value'=>'', 'label'=>'Any'));
        return $customerGroups;
    }
    /**
     * Get maximum upload size message
     *
     * @return \Magento\Framework\Phrase
     */
    public function getMaxUploadSizeMessage()
    {
        $maxFileSize = $this->fileSize->getMaxFileSizeInMb();
        if ($maxFileSize) {
            $message = __('The maximum file size limit is %1M.', $maxFileSize);
        } else {
            $message = __('We can\'t provide the upload settings right now.');
        }
        return $message;
    }
}
