<?php
namespace Expedux\Customerdoc\Block;
use Magento\Framework\App\ResourceConnection;

class Category extends \Magento\Framework\View\Element\Template
{
    protected $storeManager;
	public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Expedux\Customerdoc\Model\ResourceModel\Document\CollectionFactory $documentFactory,
        \Expedux\Customerdoc\Model\ResourceModel\Category\CollectionFactory $catdocFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Model\Session $customerSession,
        ResourceConnection $resource
    )
    {      
        $this->documentFactory = $documentFactory; 
        $this->catdocFactory = $catdocFactory;
        $this->storeManager = $storeManager;
        $this->_resource = $resource;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }
	public function getMyDocuments()
    {

        $connection = $this->_resource->getConnection();
        $select = 'SELECT * FROM customer_letters WHERE customer_id = 1';
    
        return $connection->fetchAll($select);
    }
    public function getAllGroupId(){
        $groupId = array('1');
        if($this->_customerSession->isLoggedIn()):
            $groupId[] = $this->_customerSession->getCustomer()->getGroupId();
        endif;        
        $groupId = array_unique($groupId);
        $catArry = array();  
        foreach($groupId as $id){
            $doccollection = $this->documentFactory->create();
            $doccollection->addFieldToFilter("customer_group", $id);
            $doccollection->setPageSize(1);  
            foreach($doccollection as $doc){
             $catArry[$id] = $doc->getCustomerCategory();
            }
        }
        return $catArry;
    }
    public function getDocsCollection($gId,$gky){        
        $doccollection = $this->documentFactory->create();
        $doccollection->addFieldToFilter("customer_category", $gId);
        $doccollection->addFieldToFilter("customer_group", $gky);
        return $doccollection;
    }
    public function getcategoryNameById($gId){        
        $doccatcollection = $this->catdocFactory->create();
        $doccatcollection->addFieldToFilter("category_id", $gId);
        $catname = ''; 
        foreach($doccatcollection->getData() as $cat){
            $catname = $cat['category_name']; 
        }
        return $catname;
    }    
    public function getDocumentPath(){
        return $this->storeManager
                     ->getStore()
                     ->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
    }
    
}
