<?php

namespace Expedux\Customerdoc\Controller\Adminhtml\Category;

class Save extends \Magento\Backend\App\Action
{

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\Customerdoc\Model\CategoryFactory $categoryFactory
    ) {
        parent::__construct($context);
        $this->categoryFactory = $categoryFactory;
    }


    public function execute()
    {  
        $data = $this->getRequest()->getPostValue();
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try { 
            
            $rowData = $this->categoryFactory->create();

            $values = $rowData->getCollection();
                        if(isset($data['category_id'])){
                            $values->addFieldToFilter('category_id',['neq'=> $data['category_id']]);
                        }
                    $values->addFieldToFilter('category_name',['eq'=> $data['category_name']]);

            if(!$values->getSize())
            {
                    $rowData->setData($data);
                    $rowData->save();
                    $this->messageManager->addSuccess(__('Category has been successfully saved.'));
                    $this->_redirect('*/*/index');
            }else{
                $this->messageManager->addError(__('Category already is there.'));
                if($this->_request->getParam('category_id')){
                    $this->_redirect('*/*/addnew', ['category_id' => $this->_request->getParam('category_id')]);
                }else{
                    $this->_redirect('*/*/addnew');  
                }
            }
          

            
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }

}
