<?php

namespace Expedux\Customerdoc\Controller\Adminhtml\Document;

use Magento\Framework\Controller\ResultFactory;

class Addnew extends \Magento\Backend\App\Action{
    
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Expedux\Customerdoc\Model\DocumentFactory $documentFactory
    ) {
        parent::__construct($context);
        $this->coreRegistry = $coreRegistry;
        $this->documentFactory = $documentFactory;
    }
    public function execute()
    {
        $rowId = (int) $this->getRequest()->getParam('id');
        $rowData = $this->documentFactory->create();

        if($rowId){
            $rowData = $rowData->load($rowId);
            if(!$rowData->getId()){
                $this->messageManager->addError(__('Column not exist'));
                $this->_redirect('*/*/index');
                return;
            }
        }
        $this->coreRegistry->register('row_data', $rowData);
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $title = $rowId ? __('Edit Document'): __('Add Document');
        $resultPage->getConfig()->getTitle()->prepend($title);
       
        return $resultPage;
    }

}
