<?php

namespace Expedux\Customerdoc\Controller\Adminhtml\Document;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\MediaStorage\Model\File\UploaderFactory;
use Magento\Framework\Filesystem;
class Save extends \Magento\Backend\App\Action
{
    protected $uploaderFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\Customerdoc\Model\DocumentFactory $documentFactory,
        Filesystem $fileSystem,
        UploaderFactory $uploaderFactory 
    ) {
        parent::__construct($context);
        $this->documentFactory = $documentFactory;
        $this->uploaderFactory = $uploaderFactory; 
        $this->fileSystem = $fileSystem;
    }


    public function execute()
    {  

        $data = $this->getRequest()->getPostValue();
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $fileSystem = $objectManager->create('\Magento\Framework\Filesystem');
        $mediaPath  =   $fileSystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)->getAbsolutePath();
        $media  =  $mediaPath.'documents/' ;
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try { 
            
            $rowData = $this->documentFactory->create();

            $values = $rowData->getCollection();
                        if(isset($data['document_id'])){
                            $values->addFieldToFilter('document_id',['neq'=> $data['document_id']]);
                        }
                    $values->addFieldToFilter('document_name',['eq'=> $data['document_name']]);

            if(!$values->getSize())
            {
                
                // $files = $this->getRequest()->getFiles();
                // echo "<pre>";print_r($files);exit;
                // $uploader = $this->uploaderFactory->create(['fileId' => 'file_path']);
                // $uploader->setFilesDispersion(false);
                // $uploader->setFilenamesCaseSensitivity(false);
                // $uploader->setAllowRenameFiles(true);
                
                // $_FILES['file_path']['name'] = str_replace(' ', '-', $_FILES['file_path']['name']);
                // $path =$media ;
                
                // #$uploader->save($path, $_FILES[$field]['name']);
                // $result = $uploader->save($path);

                //     $data['file_path'] = "documents/".$uploader->getUploadedFileName();
                    $result = $this->saveFile('file_path');
                    $data['customer_group'] = implode(',',$this->getRequest()->getPost('customer_groups'));

                    if(!empty($result)){
                       $data['file_path'] = $result;
                      }
                        
                    $rowData->setData($data);
                    $rowData->save();
                    $this->messageManager->addSuccess(__('Document has been successfully saved.'));
                    $this->_redirect('*/*/index');
            }else{
                $this->messageManager->addError(__('Document already is there.'));
                if($this->_request->getParam('document_id')){
                    $this->_redirect('*/*/addnew', ['document_id' => $this->_request->getParam('document_id')]);
                }else{
                    $this->_redirect('*/*/addnew');  
                }
            }
          

            
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }
    public function saveFile($image)
    {

        $imageRequest = $this->getRequest()->getFiles($image);
        
        if ($imageRequest && $imageRequest['name'] != '') {
            try {
                    $destinationPath = $this->getDestinationPath();
                    $uploader = $this->uploaderFactory->create(['fileId' => 'file_path']);
                    #$uploader->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png']);
                    $uploader->setAllowRenameFiles(true);
                    $uploader->setFilesDispersion(true);

                    $mediaDirectory = $this->_objectManager->get('Magento\Framework\Filesystem')->getDirectoryRead(DirectoryList::MEDIA);
                    $result = $uploader->save($mediaDirectory->getAbsolutePath('documents/file_path'));
                    $imagePath = $result['file'];
                    return $imagePath; 
                    } catch (\Exception $e) {
                    if ($e->getCode() == 0) {
                        $this->messageManager->addError($e->getMessage());
                    }
                }
            } else {
                $data = $this->getRequest()->getPostValue();
            if (isset($data[$image]) && isset($data[$image]['value'])) {
                if (isset($data[$image]['delete'])) {
                    return null;
                } elseif (isset($data[$image]['value'])) {
                    return $data[$image]['value'];
                } else {
                    return null;
                }
            }
        }
        
    }
    public function getDestinationPath()
    {
        return $this->fileSystem
            ->getDirectoryWrite(DirectoryList::MEDIA)
            ->getAbsolutePath('/');
    }

}
