<?php
namespace Expedux\Customerdoc\Controller\Category;
class Download extends \Magento\Framework\App\Action\Action
{       
        /**
         * @param \Magento\Framework\App\Action\Context $context
         * @param \Magento\Framework\View\Result\PageFactory resultPageFactory
         */
        public function __construct(
            \Magento\Framework\App\Action\Context $context,
            \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
            \Magento\Framework\Filesystem\DirectoryList $directory,
            \Magento\Framework\App\Request\Http $request,
            \Expedux\Customerdoc\Model\ResourceModel\Document\CollectionFactory $documentFactory
        )
        {
            $this->_downloader =  $fileFactory;
            $this->directory = $directory;
            $this->request = $request;
            $this->documentFactory = $documentFactory; 
            parent::__construct($context);
        }
    /**
     * Default customer account page
     *
     * @return void
     */
    public function execute()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
        $urlInterface = $objectManager->get('\Magento\Framework\UrlInterface');
        if(!$customerSession->isLoggedIn()) {
            $customerSession->setAfterAuthUrl($urlInterface->getCurrentUrl());
            $customerSession->authenticate();
        }
        if ($this->request->getParam('id'))  {
           $fileName = "";
           $doccollection = $this->documentFactory->create()->addFieldToFilter("document_id",$this->request->getParam('id'));
           foreach($doccollection as $doc){
            $fileName = $doc->getFilePath();
           }
            $file = $this->directory->getPath("media")."/documents/file_path/".$fileName;
            if (empty($fileName)) {
                $this->messageManager->addErrorMessage(__('Cannot download this file1'));
                return $this->resultRedirectFactory->create()->setPath(
                    'customerdoc/category/index/',
                    [                            
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );
            }
            if (! is_file ( $file ) || ! is_readable ( $file )) {
                $this->messageManager->addErrorMessage(__('Cannot download this file'));
                return $this->resultRedirectFactory->create()->setPath(
                    'customerdoc/category/index/',
                    [                            
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );
            }
        return $this->_downloader->create(
            substr($fileName, 5),
            @file_get_contents($file),
            $this->directory::VAR_DIR
        );
        }
        //return $this->resultPageFactory->create();
       
    }
}
?>