<?php
namespace Expedux\Customerdoc\Controller\Category;
class Letters extends \Magento\Framework\App\Action\Action
{       
        /**
         * @param \Magento\Framework\App\Action\Context $context
         * @param \Magento\Framework\View\Result\PageFactory resultPageFactory
         */
        public function __construct(
            \Magento\Framework\App\Action\Context $context,
            \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
            \Magento\Framework\Filesystem\DirectoryList $directory,
            \Magento\Framework\App\Request\Http $request,
            \Expedux\Customerdoc\Model\ResourceModel\Document\CollectionFactory $documentFactory
        )
        {
            $this->_downloader =  $fileFactory;
            $this->directory = $directory;
            $this->request = $request;
            $this->documentFactory = $documentFactory; 
            parent::__construct($context);
        }
    /**
     * Default customer account page
     *
     * @return void
     */
    public function execute()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
        $urlInterface = $objectManager->get('\Magento\Framework\UrlInterface');
        if(!$customerSession->isLoggedIn()) {
            $customerSession->setAfterAuthUrl($urlInterface->getCurrentUrl());
            $customerSession->authenticate();
        }
        if ($this->request->getParam('id'))  {
            $docId = $this->request->getParam('id');
            $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
            $connection = $resource->getConnection();
            $tableName = $resource->getTableName('customer_letters');
            $customerId = $customerSession->getId();
            $customerEmail = $customerSession->getCustomer()->getEmail();
            $letterssql= "SELECT file_name FROM " . $tableName . " WHERE customer_letters_id='".$docId."' and (customer_id='".$customerId."' OR parent_id='".$customerId."' OR email='".$customerEmail."')";
            $allletter = $connection->fetchOne($letterssql); 
            if (empty($allletter)) {
                $this->messageManager->addErrorMessage(__('Cannot download this file'));
                return $this->resultRedirectFactory->create()->setPath(
                    'customerdoc/category/index/',
                    [                            
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );
            }
           
        $filepath = $this->directory->getPath("media")."/customer/pdf/".$allletter;
        if (! is_file ( $filepath ) || ! is_readable ( $filepath )) {
            $this->messageManager->addErrorMessage(__('Cannot download this file'));
            return $this->resultRedirectFactory->create()->setPath(
                'customerdoc/category/index/',
                [                            
                    '_secure' => $this->getRequest()->isSecure(),
                ]
            );
        }
         
        return $this->_downloader->create(
            $allletter,
            @file_get_contents($filepath),
            $this->directory::VAR_DIR,
        );
        }
        //return $this->resultPageFactory->create();
       
    }
}
?>