<?php
namespace Expedux\Customerdoc\Controller\Category;
use Magento\Store\Model\StoreManagerInterface;
class View extends \Magento\Framework\App\Action\Action
{       
        /**
         * @param \Magento\Framework\App\Action\Context $context
         * @param \Magento\Framework\View\Result\PageFactory resultPageFactory
         */
        public function __construct(
            \Magento\Framework\App\Action\Context $context,
            \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
            \Magento\Framework\Filesystem\DirectoryList $directory,
            \Magento\Framework\App\Request\Http $request,
            \Expedux\Customerdoc\Model\DocumentFactory $documentFactory,
            StoreManagerInterface $storeManager
        )
        {
            $this->_downloader =  $fileFactory;
            $this->directory = $directory;
            $this->request = $request;
            $this->documentFactory = $documentFactory;
            $this->storeManager = $storeManager;
            parent::__construct($context);
        }
    /**
     * Default customer account page
     *
     * @return void
     */
    public function execute()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        $customerSession = $objectManager->get('\Magento\Customer\Model\Session');
        $urlInterface = $objectManager->get('\Magento\Framework\UrlInterface');
        if(!$customerSession->isLoggedIn()) {
            $customerSession->setAfterAuthUrl($urlInterface->getCurrentUrl());
            $customerSession->authenticate();
        }
        if ($this->request->getParam('id'))  {
            $storeMediaUrl = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA);
            $fileName = "";
            $doccollection = $this->documentFactory->create()->getCollection()->addFieldToFilter("document_id",$this->request->getParam('id'));
            foreach($doccollection as $doc){
             $fileName = $doc->getFilePath();
            }
            if (empty($fileName)) {
                $this->messageManager->addErrorMessage(__('Cannot view this file'));
                return $this->resultRedirectFactory->create()->setPath(
                    'customerdoc/category/index/',
                    [                            
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );
            }
            $file = $storeMediaUrl."documents/file_path/".$fileName;            
        
        return $this->resultRedirectFactory->create()->setPath(
            $file,
            [                            
                '_current' => false, '_secure' => $this->getRequest()->isSecure(),
            ]
        );
        }
        //return $this->resultPageFactory->create();
       
    }
}
?>
