<?php
namespace Expedux\Customerdoc\Model;
class Category extends \Magento\Framework\Model\AbstractModel implements \Magento\Framework\DataObject\IdentityInterface
{
	const CACHE_TAG = 'expedux_customerdoc_category';

	protected $_cacheTag = 'expedux_customerdoc_category';

	protected $_eventPrefix = 'expedux_customerdoc_category';

	protected function _construct()
	{
		$this->_init('Expedux\Customerdoc\Model\ResourceModel\Category');
	}

	public function getIdentities()
	{
		return [self::CACHE_TAG . '_' . $this->getId()];
	}

	public function getDefaultValues()
	{
		$values = [];

		return $values;
	}
	public function getAllOptions($withEmpty = true)
    {
     
		$objectManager = \Magento\Framework\App\ObjectManager::getInstance();

		$productCollection = $objectManager->create('Expedux\Customerdoc\Model\ResourceModel\Category\CollectionFactory');

		$collection = $productCollection->create()	
					->load();
		$options=array();
		foreach ($collection as $product){
			$options[$product->getCategoryId()]  = $product->getCategoryName() ; 
		}  

        return $options;
	}
	

}

