<?php

namespace Expedux\ExamBookings\Block\Adminhtml\Dropdown\Edit;

class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Expedux\ExamBookings\Model\DropdownCategory $dropdown,
        \Expedux\ExamBookings\Model\Status $options,
        array $data = []
    ) {
        $this->dropdown = $dropdown;
        $this->_options = $options;
        parent::__construct($context, $registry, $formFactory, $data);
    }


    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry('row_data');
        $form = $this->_formFactory->create(
            ['data' => [
                            'id' => 'edit_form',
                            'enctype' => 'multipart/form-data',
                            'action' => $this->getData('action'),
                            'method' => 'post'
                        ]
            ]
        );
        if ($model->getId()) {
        
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Edit Dropdown Value'), 'class' => 'fieldset-wide']
            );
            $fieldset->addField('dropdown_id', 'hidden', ['name' => 'dropdown_id']);
            
        } else {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Add Dropdown Value'), 'class' => 'fieldset-wide']
            );
        }
       
        $fieldset->addField(
            'dropdown_category',
            'select',
            [
                'name' => 'dropdown_category',
                'label' => __('Category'),
                'id' => 'dropdown_category',
                'title' => __('dropdown_category'),
                'class' => 'required-entry',
                'values' => $this->dropdown->getOptionArray(),
                'required' => true,
            ]
        );
        $fieldset->addField(
            'dropdown_name',
            'text',
            [
                'name' => 'dropdown_name',
                'label' => __('Dropdown Name'),
                'id' => 'dropdown_name',
                'title' => __('dropdown_name'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'status',
            'select',
            [
                'name' => 'status',
                'label' => __('Status'),
                'id' => 'status',
                'title' => __('Status'),
                'values' => $this->_options->getOptionArray(),
                'class' => 'status',
                'required' => true,
            ]
        );

        $form->setValues($model->getData());
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }

}
