<?php

namespace Expedux\ExamBookings\Controller\Adminhtml\Bookings;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\MediaStorage\Model\File\UploaderFactory;
use Magento\Framework\Filesystem;
class Save extends \Magento\Backend\App\Action
{
    protected $uploaderFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\ExamBookings\Model\BookingsFactory $bookingsFactory,        
        Filesystem $fileSystem,
        UploaderFactory $uploaderFactory 
    ) {
        parent::__construct($context);
        $this->bookingsFactory = $bookingsFactory;
        $this->uploaderFactory = $uploaderFactory; 
        $this->fileSystem = $fileSystem;        
    }


    public function execute()
    {        
        $data = $this->getRequest()->getPostValue();               
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try {                 
            $rowData = $this->bookingsFactory->create();
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
            $connection = $resource->getConnection();
            if(empty($data['booking_id'])){
                if(!empty($data['order_primary_id'])){                   
                    $order = $objectManager->create('\Magento\Sales\Model\OrderRepository')->get($data['order_primary_id']);
                    
                    $tableName = $resource->getTableName('sales_flat_order_address_delegate');
					$multidelsql= "SELECT entity_id FROM " . $tableName . " WHERE order_id ='" . $data['order_primary_id'] . "'";
					$addressArr = $connection->fetchAll($multidelsql);
                    if (count ( $addressArr ) > 0) {
                        $getprod_sql = "SELECT product_id from " . $tableName . " WHERE
                        order_id ='" . $data['order_primary_id'] . "' AND delegate_email='".$data ['delegates_email']."'";    
                        $getprod = $connection->fetchOne($getprod_sql);
                        $product = $objectManager->get('Magento\Catalog\Model\Product')->load($getprod);                        
                        $nProduct = $product->getId();
						$productsku = $product->getSku();
                    }
                    else
					{
                        $nProduct = '';
                        $productsku = '';
                        foreach ($order->getAllItems() as $sItem) {
                            if ($sItem->getProductType () == "configurable") {
                                $nProduct = $sItem->getProductId ();
                                $productsku = $sItem->getSku ();
                            } elseif ($sItem->getProductType () == "simple") {
                                $nProduct = $sItem->getProductId ();
                                $productsku = $sItem->getSku ();
                            } elseif ($sItem->getProductType () == "bundle") {
                                $nProduct = $sItem->getProductId ();
                                $productsku = $sItem->getSku ();
                            }
                        }
                    }
                    $data ['product_id'] = $nProduct;
                    $data ['product_sku'] = $productsku;
                    //Common Values for multi delegates
                    if (! empty ( $data ['request_date'] )) {
                        $data ['request_date'] = str_replace ( "/", "-", $data ['request_date'] );
                    } else {
                        $data ['request_date'] = date ( "Y-m-d" );
                    }
                    //corporte booking for multi delegates
                    if (isset($data ['is_multidelegate']) && $data ['is_multidelegate'] == 1) {
                        $tcon = $data ['delegates_count'];						
                        for($m=0; $m <= $tcon; $m++)
                        {
                            if($m == 0)
                            {
                                $mdelegates_name = $data ['delegates_name'];
                                $mdelegates_email = $data ['delegates_email'];
                            }
                            else
                            {
                                $mdelegates_name = $data ['delegates_name'.$m];
                                $mdelegates_email = $data ['delegates_email'.$m];
                            }
                          if (!empty ( $mdelegates_name ) && !empty ( $mdelegates_email )) {
                              $data ['delegates_name'] = $mdelegates_name;
                              $data ['delegates_email'] = $mdelegates_email;                     
                              $rowData->setData ( $data );
                              $rowData->save ();                              
                          }			
                        }
                        $this->messageManager->addSuccess(__('Exam Bookings was successfully saved.'));
                        $this->_redirect('*/*/index');                        
                    }else{
                        $tablebookName = $resource->getTableName('expedux_exambookings_bookings');
                        $book_qry = "Select booking_id from " . $tablebookName . " where order_id ='" . $order->getIncrementId() . "'
					 and product_id = '" . $data ['product_id'] . "' and exam_types ='" . $data ['exam_types'] . "' and delegates_email ='" . $data ['delegates_email'] . "' and status != 7 and (results IS NULL or results='1')";
                        $dbbook_id = $connection->fetchOne ( $book_qry );
                        if (! empty ( $dbbook_id )) {                           
                            $this->messageManager->addError(__('You have booked the same exam alreay or passed the exam'));						
                            $this->_redirect('*/*/addnew', ['order_id' => $data['order_primary_id']]);
                        }
                        else
                        {
                            $rowData->setData($data);
                            $rowData->save();
                            $this->messageManager->addSuccess(__('Exam Bookings was successfully saved.'));
                            $this->_redirect('*/*/index');
                        }
                    }                    
                }else{
                    $this->messageManager->addError(__('Unable to save Exam Bookings'));
                    $this->_redirect('*/*/index');
                }                
            }else{
                if (! empty ( $data ['request_date'] )) {
                    $data ['request_date'] = str_replace ( "/", "-", $data ['request_date'] );
                } else {
                    $data ['request_date'] = date ( "Y-m-d" );
                }
                //echo "<pre>";print_r($data);exit;
                $getbookdets = $rowData->getCollection()
                ->addFieldToFilter('booking_id',['eq'=> $data['booking_id']]);
                $order_id = '';
                $product_id = '';
                foreach($getbookdets as $bookdet){
                    $order_id = $bookdet['order_id'];
                    $product_id = $bookdet['product_id'];
                }                
                $tablebookName = $resource->getTableName('expedux_exambookings_bookings');
                $book_qry = "Select booking_id from " . $tablebookName . " where order_id ='" . $order_id . "'
                     and product_id = '" . $product_id . "' and exam_types ='" . $data ['exam_types'] . "' 
                     and delegates_email ='" . $data ['delegates_email'] . "' and status != 7 and (results IS NULL or results='1')
                     and booking_id !='" . $data['booking_id'] . "'";
                $dbbook_id = $connection->fetchOne ( $book_qry );
                if (! empty ( $dbbook_id )) {                           
                    $this->messageManager->addError(__('You have booked the same exam alreay or passed the exam'));						
                    $this->_redirect('*/*/addnew', ['id' => $data['booking_id']]);
                }
                else{
                    $rowData->setData($data);
                    $rowData->save();
                    $this->messageManager->addSuccess(__('Exam Bookings was successfully saved.'));
                    $this->_redirect('*/*/index');
                }                     
                
            }             
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }
}
