<?php

namespace Expedux\ExamBookings\Controller\Adminhtml\Dropdown;

use Magento\Framework\Controller\ResultFactory;

class Addnew extends \Magento\Backend\App\Action{
    
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Expedux\ExamBookings\Model\DropdownFactory $dropdownFactory
    ) {
        parent::__construct($context);
        $this->coreRegistry = $coreRegistry;
        $this->dropdownFactory = $dropdownFactory;
    }
    public function execute()
    {
        $rowId = (int) $this->getRequest()->getParam('id');
        $rowData = $this->dropdownFactory->create();

        if($rowId){
            $rowData = $rowData->load($rowId);
            if(!$rowData->getId()){
                $this->messageManager->addError(__('Column not exist'));
                $this->_redirect('*/*/index');
                return;
            }
        }
        $this->coreRegistry->register('row_data', $rowData);
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $title = $rowId ? __('Edit Dropdown Values'): __('Add Dropdown Values');
        $resultPage->getConfig()->getTitle()->prepend($title);
       
        return $resultPage;
    }

}
