<?php

namespace Expedux\ExamBookings\Model;

use Magento\Framework\Data\OptionSourceInterface;

class DropdownValues implements OptionSourceInterface
{
    /**
     * Get Grid row status type labels array.
     * @return array
     */
    public function getOptionArray()
    {
        $options = ['1' => __('Enabled'),'0' => __('Disabled')];
        return $options;
    }

    /**
     * Get Grid row status labels array with empty value for option element.
     *
     * @return array
     */
    public function getAllExamTypes()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

		$productCollection = $objectManager->create('Expedux\ExamBookings\Model\ResourceModel\Dropdown\Collection');

		$collection = $productCollection->addFieldToFilter('dropdown_category','1');
		$options=array();
		foreach ($collection as $product){
			$options[$product->getDropdownId()]  = $product->getDropdownName(); 
		}  

        return $options;

    }
    /**
     * Get Grid row status labels array with empty value for option element.
     *
     * @return array
     */
    public function getAllExamSlots()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

		$productCollection = $objectManager->create('Expedux\ExamBookings\Model\ResourceModel\Dropdown\Collection');

		$collection = $productCollection->addFieldToFilter('dropdown_category','2');
		$options=array();
		foreach ($collection as $product){
			$options[$product->getDropdownId()]  = $product->getDropdownName(); 
		}  

        return $options;

    }
    /**
     * Get Grid row status labels array with empty value for option element.
     *
     * @return array
     */
    public function getAllExamMode()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

		$productCollection = $objectManager->create('Expedux\ExamBookings\Model\ResourceModel\Dropdown\Collection');

		$collection = $productCollection->addFieldToFilter('dropdown_category','3');
		$options=array();
		foreach ($collection as $product){
			$options[$product->getDropdownId()]  = $product->getDropdownName(); 
		}  

        return $options;

    }

    /**
     * Get Grid row type array for option element.
     * @return array
     */
    public function getOptions()
    {
        $res = [];
        foreach ($this->getOptionArray() as $index => $value) {
            $res[] = ['value' => $index, 'label' => $value];
        }
        return $res;
    }

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return $this->getOptions();
    }
}