<?php

namespace Expedux\ExamBookings\Model;

use Magento\Framework\Data\OptionSourceInterface;

class ExamTypes implements OptionSourceInterface
{
    /**
     * Get Grid row status type labels array.
     * @return array
     */
    public function getOptionArray()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
		$productCollection = $objectManager->create('Expedux\ExamBookings\Model\ResourceModel\Dropdown\Collection');
		$collection = $productCollection->addFieldToFilter('dropdown_category','1');
		$options=array();
		foreach ($collection as $product){
			$options[$product->getDropdownId()]  = $product->getDropdownName(); 
		}
        return $options;
    }

    /**
     * Get Grid row status labels array with empty value for option element.
     *
     * @return array
     */
    public function getAllOptions()
    {
        $res = $this->getOptions();
        array_unshift($res, ['value' => '', 'label' => '']);
        return $res;
    }

    /**
     * Get Grid row type array for option element.
     * @return array
     */
    public function getOptions()
    {
        $res = [];
        foreach ($this->getOptionArray() as $index => $value) {
            $res[] = ['value' => $index, 'label' => $value];
        }
        return $res;
    }

    /**
     * {@inheritdoc}
     */
    public function toOptionArray()
    {
        return $this->getOptions();
    }
}
