<?php
namespace Expedux\ExamBookings\Setup;

class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{

	public function install(\Magento\Framework\Setup\SchemaSetupInterface $setup, \Magento\Framework\Setup\ModuleContextInterface $context)
	{
		$installer = $setup;
		$installer->startSetup();
		if (!$installer->tableExists('expedux_exambookings_bookings')) {
			$table = $installer->getConnection()->newTable(
				$installer->getTable('expedux_exambookings_bookings')
			)
				->addColumn(
					'booking_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					[
						'identity' => true,
						'nullable' => false,
						'primary'  => true,
						'unsigned' => true,
					],
					'Booking ID'
				)
				->addColumn(
					'order_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					['nullable => false'],
					'Order ID'
				)
				->addColumn(
					'is_multidelegate',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					null,
					['nullable => false'],
					'Is Multideletegate'
				)
				->addColumn(
					'certificate_name',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable => false'],
					'Certificate Name'
				)
				->addColumn(
					'results',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable => false'],
					'Results'
				)
				->addColumn(
					'delegates_name',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable => false'],
					'Delegates Name'
				)
				->addColumn(
					'delegates_email',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					255,
					['nullable => false'],
					'Delegates Email'
				)
				->addColumn(
					'exam_date',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'Exam Date'
			    )
				
				->addColumn(
					'exam_slot',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Exam Slot'
			    )
				->addColumn(
					'exam_mode',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Exam Mode'
			    )
				->addColumn(
					'exam_types',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Exam Types'
			    )
				->addColumn(
					'apmg_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'APMG Booking Id'
			    )
				->addColumn(
					'apmg_invoice',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'APMG Invoice'
				)
				->addColumn(
					'product_id',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Product Id'
				)
				->addColumn(
					'product_sku',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Product Sku'
				)
				->addColumn(
					'course_sku',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Course Sku'
			    )
				->addColumn(
					'candidate_no',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Candidate No'
			    )
				->addColumn(
					'request_date',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
					'Request Date'
			    )
				->addColumn(
					'status',
					\Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
					1,
					[],
					'Booking Status'
				)
				->addColumn(
					'customer_comments',
					\Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
					null,
					['nullable' => false],
					'Cstomer Comments'
			    )
				->addColumn(
						'created_at',
						\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
						null,
						['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
						'Created At'
				)
				->addColumn(
					'updated_at',
					\Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
					null,
					['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
					'Updated At')
				->setComment('Category Table');
			$installer->getConnection()->createTable($table);

			$installer->getConnection()->addIndex(
				$installer->getTable('expedux_exambookings_bookings'),
				$setup->getIdxName(
					$installer->getTable('expedux_exambookings_bookings'),
					['delegates_name'],
					\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
				),
				['delegates_name'],
				\Magento\Framework\DB\Adapter\AdapterInterface::INDEX_TYPE_FULLTEXT
			);
		}
		$installer->endSetup();
	}
}

