<?php

namespace Expedux\InvoiceExport\Controller\Adminhtml\InvoiceExport;
use Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Export extends \Magento\Backend\App\Action {
        
        public function __construct(
            \Magento\Backend\App\Action\Context $context,
            \Magento\Framework\View\Result\PageFactory $resultPageFactory,
            \Magento\Catalog\Model\ProductRepository $productRepository,
            \Expedux\InvoiceExport\Helper\Data $helperData,
            \Magento\Customer\Model\Customer $customer,
            \Magento\Sales\Api\OrderRepositoryInterface $orderRepository
        ) {
            parent::__construct($context);
            $this->resultPageFactory = $resultPageFactory;
            $this->orderRepository = $orderRepository;
            $this->helperData = $helperData;
            $this->customer = $customer;
            $this->_productRepository = $productRepository;
           
        }

        public function execute()
        {
            $resultRedirect = $this->resultRedirectFactory->create();

            $post = $this->getRequest()->getPostValue();
             if($post){
                $output = "";
                if(!empty($post['quick_books']) && $post['quick_books'] ==1)
                {
                    $output .= "*InvoiceNo,*Customer,*InvoiceDate,*DueDate,Terms,Location,Memo,Item(Product/Service),ItemDescription,ItemQuantity,ItemRate,*ItemAmount,*ItemTaxCode,ItemTaxAmount,ServiceDate";
                }
                else{
                    $output .= "Type,AccountReference,NominalA/CRef,DepartmentCode,Date,Reference,Details,NetAmount,TaxCode,TaxAmount,ExchangeRate,ExtraReference,UserName,ProjectRefn,CostCodeRefn";
                }
                $output .="\n";

                if(!empty($post['order_from']))
                {
                    $fromDate = date('Y-m-d H:i:s', strtotime(str_replace("/","-",$post['order_from'])));
                }
                if(!empty($post['order_to']))
                {
                    $toDate = date('Y-m-d', strtotime(str_replace("/","-",$post['order_to'])));
                    if($toDate == date('Y-m-d'))
                    {
                        $toTime = date('H:i:s');
                    }
                    else
                    {
                        $toTime = "23:59:00";
                    }
                    $toDate .= " ".$toTime;
                }

                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $invoices = $objectManager->get(\Magento\Sales\Model\ResourceModel\Order\Invoice\Collection::class);
                
                if(!empty($post['order_from']) || !empty($post['order_to']))
                {
                    if(!empty($post['order_from']) && empty($post['order_to']))
                    {
                        $toDate = date('Y-m-d H:i:s');
                    }
                    if(empty($post['order_from']) && !empty($post['order_to']))
                    {
                        $fromDate = '2017-01-01';
                    }
                    $invoices->addAttributeToFilter('created_at', array('from'=>$fromDate, 'to'=>$toDate));
                }
                if(!empty($post['invoice_id']))
                {
                    $invoices->addAttributeToFilter('increment_id', array('gteq' => $post['invoice_id']));
                }
                $rows = array();
                $quick_book_rows = array();
                $inc = 0;
                
                foreach ($invoices as $invoice) {
                
                    $_order = $this->orderRepository->get( $invoice ['order_id'] );
                   
                    if(!empty($post['quick_books']) && $post['quick_books'] ==1)
                        {
                            $order_Address = $_order->getBillingAddress()->getData();
                            $orderAddressInterface = $objectManager->get(\Magento\Sales\Api\Data\OrderAddressInterfaceFactory::class);
                            $address = $orderAddressInterface->create(['data' => $order_Address]);
                            $order_Address_text =  $objectManager->get(\Magento\Sales\Model\Order\Address\Renderer::class)->format($address, 'oneline');;
                
                            $statusHistory = $_order->getStatusHistoryCollection()->getData();
                            $status_array = array();
                            foreach($statusHistory as $status)
                            {
                                $status_array [] = $status['comment'];
                            }

                            $status_txt = implode(PHP_EOL,$status_array);

                            // if($_order->getCustomerId()){
                            //     $customer_id = $_order->getCustomerId();	
                            //     $customerData = $this->customer->load($customer_id); // then load customer by customer id
                            //     $customerName = $customerData->getName();
                            // }else{
                            //     $customerName = $_order->getCustomerName();
                            // }

                            $customerName = $_order->getCustomerName();
                           
                        }
                        $items = $_order->getAllVisibleItems ();

                        $r = 1;
				        $item_count = count($items);

                        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

                        foreach ( $items as $item ) {

                            $productModel =  $objectManager->create('Magento\Catalog\Model\Product')->load($item->getProductId());
                            if($productModel->getId()){
                            $prod = $this->_productRepository->getById($item->getProductId());
                            $nominalcodes = "";
                            if (! empty ( $prod->getAttributeText ( 'dates' ) )) {
                                $date_arr = explode ( "-", $prod->getAttributeText ( 'dates' ) );
                                 $to = '';
                                 if (isset($date_arr [1] )) {
                                 	$to = trim ( $date_arr [1] );
                                 }
                                
                                if (! empty ( $to )) {
                                    $getmonth = explode ( "/", $to );
                                    $nominalcodes = $this->helperData->getNominalCodes((int)$getmonth[1]);
                                }
                            }
                            else{$nominalcodes = "2127";}
                            $departments = "";
                            if (! empty ( $prod->getAttributeText ( 'location' ) )) {
                                $departments = $this->helperData->getDepartments($prod->getAttributeText ('location'));
                            }
                            else{$departments = "7";}
                            $invoiceDate = date('d-m-Y', strtotime($invoice ['created_at']));
                            $tax = $_order->getFullTaxInfo();
                            //echo "<pre>";print_r($invoice ['increment_id']);print_r($tax);exit;
                            if(!empty($tax))
                            {
                                $taxcode = $this->helperData->getTaxCodes($tax[0]['rates'][0]['code']);
                            }
                            else
                            {
                                $taxcode = "T4";
                            }
                            $rows [$inc][] = $_order->getCustomerId ();
                            $rows [$inc][] = $nominalcodes;
                            $rows [$inc][] = $departments;
                            $rows [$inc][] = $invoiceDate;
                            $rows [$inc][] = $invoice ['increment_id'];
                            $rows [$inc][] = $item->getName ();
                            $rows [$inc][] = $item->getRowTotal () - $item->getDiscountAmount ();
                            $rows [$inc][] = $taxcode;
                            $rows [$inc][] = $item->getTaxAmount();		
                            if(!empty($post['quick_books']) && $post['quick_books'] ==1)
                            {
                                $orderDate = date('d-m-Y', strtotime($_order['created_at']));
                                $invoiceDueDate = date('d-m-Y', strtotime($invoiceDate. ' + 15 days'));
                                $shippingAmount = $invoice['shipping_amount'];	
                                $terms = 'Net 15';
                                $location = '';
                                //$memo =  'Order # '.$_order->getIncrementId (). PHP_EOL.$status_txt;
                                $memo =  'Order # '.$_order->getIncrementId ();
                                $quick_book_rows [$inc][]  = $invoice ['increment_id'];
                                $quick_book_rows [$inc][]  = $customerName;
                                $quick_book_rows [$inc][]  = $invoiceDate;
                                $quick_book_rows [$inc][]  = $invoiceDueDate;
                                $quick_book_rows [$inc][]  =$terms;
                                $quick_book_rows [$inc][]  =$order_Address_text;
                                $quick_book_rows [$inc][]  =$memo;
        
                                $quick_book_rows [$inc][]  = $item->getSku ();
                                $quick_book_rows [$inc][]  = $item->getName ();
                                $quick_book_rows [$inc][]  = $item->getQtyInvoiced ();
                                $quick_book_rows [$inc][]  = $item->getPrice ();
                                $quick_book_rows [$inc][] = $item->getRowTotal () - $item->getDiscountAmount ();
                                $quick_book_rows [$inc][] = ($item->getTaxPercent() > 0) ? round($item->getTaxPercent(), 2).'%':'0%';
                                $quick_book_rows [$inc][] = $item->getTaxAmount();
                                $quick_book_rows [$inc][] = $orderDate;

                                if($item_count == $r and $shippingAmount > 0) {
                                    $inc++;
                                    $quick_book_rows [$inc][]  = $invoice ['increment_id'];
                                    $quick_book_rows [$inc][]  = $customerName;
                                    $quick_book_rows [$inc][]  = $invoiceDate;
                                    $quick_book_rows [$inc][]  = $invoiceDueDate;
                                    $quick_book_rows [$inc][]  = $terms;
                                    $quick_book_rows [$inc][]  = $order_Address_text;
                                    $quick_book_rows [$inc][]  = $memo;
                                    
                                    
        
                                    $quick_book_rows [$inc][]  = 'SHIPPING-AMOUNT';
                                    $quick_book_rows [$inc][]  = 'Shipping Amount';
                                    $quick_book_rows [$inc][]  = 1;
                                    $quick_book_rows [$inc][]  = $shippingAmount;
                                    $quick_book_rows [$inc][] = $shippingAmount;
                                    $quick_book_rows [$inc][] = '';
                                    $quick_book_rows [$inc][] = $item->getShippingTaxAmount();
                                    $quick_book_rows [$inc][] = $orderDate;						
                                }

                            }			
                            $inc++;
                            $r++;
                            }
                        }

                }
        
                if(count($quick_book_rows) > 0 && !empty($post['quick_books']) && $post['quick_books'] ==1)
		{
			foreach($quick_book_rows as $quick_book_row)
			{
					$output .= '"'.$quick_book_row[0].'",'.'"'.$quick_book_row[1].'",'.'"'.$quick_book_row[2].'",'.'"'.$quick_book_row[3].'",'.'"'.$quick_book_row[4].'",'.'"'.$quick_book_row[5].'",'.'"'.$quick_book_row[6].'",'.'"'.$quick_book_row[7].'",'.'"'.$quick_book_row[8].'",'.'"'.$quick_book_row[9].'",'.'"'.$quick_book_row[10].'",'.'"'.$quick_book_row[11].'",'.'"'.$quick_book_row[12].'",'.'"'.$quick_book_row[13].'",'.'"'.$quick_book_row[14].'"';
					$output .="\n";
			}
			
			$filename =  "export_quick_books".date('Ymd').".csv";
			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);		
			echo $output;
			exit;
		}
		elseif(count($rows) > 0)
		{	$extype = "SI";
			foreach($rows as $row)
			{
				 $output .= '"'.$extype.'",'.'"'.$row[0].'",'.'"'.$row[1].'",'.'"'.$row[2].'",'.'"'.$row[3].'",'.'"'.$row[4].'",'.'"'.$row[5].'",'.'"'.$row[6].'",'.'"'.$row[7].'",'.'"'.$row[8].'",';
				 $output .="\n";
			}
			
			$filename =  "export_invoices".date('Ymd').".csv";
			header('Content-type: application/csv');
			header('Content-Disposition: attachment; filename='.$filename);		
			echo $output;
			exit;
		}
		else
		{
            $this->messageManager->addError('No data found');
            return $resultRedirect->setPath('*/*/');

        }	
        }
        else 
            {
                $this->messageManager->addError('Invalid form data.');
                return $resultRedirect->setPath('*/*/');
            }	

    }

}
