<?php

namespace Expedux\InvoiceExport\Controller\Adminhtml\InvoiceExport;
use Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class ExportMemo extends \Magento\Backend\App\Action {
        
        /**
        * @var \Magento\Framework\View\Result\PageFactory
        */
        protected $resultPageFactory;

        /**
         * Constructor
         *
         * @param \Magento\Backend\App\Action\Context $context
         * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
         */
        public function __construct(
            \Magento\Backend\App\Action\Context $context,
            \Magento\Framework\View\Result\PageFactory $resultPageFactory,
            \Magento\Catalog\Model\ProductRepository $productRepository,
            \Expedux\InvoiceExport\Helper\Data $helperData,
            \Magento\Sales\Api\OrderRepositoryInterface $orderRepository
        ) {
            parent::__construct($context);
            $this->resultPageFactory = $resultPageFactory;
            $this->orderRepository = $orderRepository;
            $this->helperData = $helperData;
            $this->_productRepository = $productRepository;
           
        }

        /**
         * @return \Magento\Framework\View\Result\Page
         */
        public function execute()
        {
            $resultRedirect = $this->resultRedirectFactory->create();
            $post = $this->getRequest()->getPostValue();
            if($post){
                $output = "";
                $output .= "Type,AccountReference,NominalA/CRef,DepartmentCode,Date,Reference,Details,Net Amount,TaxCode,TaxAmount,ExchangeRate,ExtraReference,UserName,ProjectRefn,CostCodeRefn";
                $output .="\n";
        
                if(!empty($post['memo_from']))
                {
                    $fromDate = date('Y-m-d H:i:s', strtotime(str_replace("/","-",$post['memo_from'])));
                }
                if(!empty($post['memo_to']))
                {
                    $toDate = date('Y-m-d', strtotime(str_replace("/","-",$post['memo_to'])));
                    if($toDate == date('Y-m-d'))
                    {
                    $toTime = date('H:i:s');				
                    }
                    else 
                    {
                        $toTime = "23:59:00";
                    }
                    $toDate .= " ".$toTime;
                }
                
                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $creditmemos = $objectManager->get(\Magento\Sales\Model\ResourceModel\Order\Creditmemo\Collection::class);
                        
                if(!empty($post['memo_from']) || !empty($post['memo_to']))
                {
                    if(!empty($post['memo_from']) && empty($post['memo_to']))
                    {
                        $toDate = date('Y-m-d H:i:s');
                    }
                    if(empty($post['memo_from']) && !empty($post['memo_to']))
                    {
                        $fromDate = '2017-01-01';
                    }
                    $creditmemos->addAttributeToFilter('created_at', array('from'=>$fromDate, 'to'=>$toDate));
                }
                
                if(!empty($post['memo_id']))
                {
                    $creditmemos->addAttributeToFilter('increment_id', array('gteq' => $post['memo_id']));
                }
                
                $rows = array();
                $inc = 0;
                foreach ( $creditmemos as $creditmemo ) {
                    
                        $_order = $this->orderRepository->get( $creditmemo ['order_id'] );
                        $items = $_order->getAllVisibleItems ();
                        foreach ( $items as $item ) {
                            $prod = $this->_productRepository->getById( $item->getProductId () );
                            $nominalcodes = "";
                            if (! empty ( $prod->getAttributeText ( 'dates' ) )) {
                                $date_arr = explode ( "-", $prod->getAttributeText ( 'dates' ) );
                                $to = trim ( $date_arr [1] );
                                if (! empty ( $to )) {
                                    $getmonth = explode ( "/", $to );
                                    $nominalcodes = $this->helperData->getNominalCodes ( ( int ) $getmonth [1] );
                                }
                            }
                            else{$nominalcodes = "2127";}
                            $departments = "";
                            if (! empty ( $prod->getAttributeText ( 'location' ) )) {
                                $departments = $this->helperData->getDepartments($prod->getAttributeText ('location'));
                            }
                            else{$departments = "7";}
                            $creditmemoDate = date('d-m-Y', strtotime($creditmemo ['created_at']));
                            $tax = $_order->getFullTaxInfo();
                            if(!empty($tax))
                            {
                                $taxcode = $this->helperData->getTaxCodes($tax[0]['rates'][0]['code']);
                            }
                            else
                            {
                                $taxcode = "T4";
                            }
                            $rows [$inc][] = $_order->getCustomerId ();
                            $rows [$inc][] = $nominalcodes;
                            $rows [$inc][] = $departments;
                            $rows [$inc][] = $creditmemoDate;
                            $rows [$inc][] = $creditmemo ['increment_id'];
                            $rows [$inc][] = $item->getName ();
                            $rows [$inc][] = $item->getPrice ();
                            $rows [$inc][] = $taxcode;
                            $rows [$inc][] = $item->getTaxAmount();
                            $inc++;
                        }
                    
                }
        
                if(count($rows) > 0)
                {	
                    $extype = "SC";
                foreach($rows as $row)
                {
                    $output .= '"'.$extype.'",'.'"'.$row[0].'",'.'"'.$row[1].'",'.'"'.$row[2].'",'.'"'.$row[3].'",'.'"'.$row[4].'",'.'"'.$row[5].'",'.'"'.$row[6].'",'.'"'.$row[7].'",'.'"'.$row[8].'",';
                    $output .="\n";
                }
        
                $filename =  "export_creditmemos".date('Ymd').".csv";
                header('Content-type: application/csv');
                header('Content-Disposition: attachment; filename='.$filename);
                echo $output;
                exit;
                }
                else
                {
                   
                    $this->messageManager->addError('No data found');
                    return $resultRedirect->setPath('*/*/');
                }
            }
            else
            {
                $this->messageManager->addError('Invalid form data.');
                return $resultRedirect->setPath('*/*/');
            }
           
    }

}