<?php

namespace Expedux\Lms\Controller\Adminhtml\Lms;

use Magento\Backend\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\App\ResourceConnection;


class Lmsaccess extends \Magento\Backend\App\Action
{

    public $resultPageFactory;

    public function __construct(
        Context $context,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Expedux\Checkout\Model\OrderAddressDelegateFactory $orderAddressDelegate,
        \Magento\Catalog\Model\ProductRepository $productRepository,
        \Magento\Customer\Model\CustomerExtractor $customerExtractor,
        \Magento\Customer\Api\AccountManagementInterface $accountManagement,
        \Magento\Customer\Model\Customer $customer,
        \Expedux\Lms\Model\LmsModel $lmsModel,
        \Magento\Sales\Model\Order $order,
        \Magento\Customer\Model\AddressFactory $addressFactory,
        ResourceConnection $resource,
        \Magento\Backend\Model\Auth\Session $authSession,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->orderRepository = $orderRepository;
        $this->orderAddressDelegate = $orderAddressDelegate;
        $this->_productRepository = $productRepository;
        $this->customerExtractor  = $customerExtractor;
		$this->accountManagement  = $accountManagement;
        $this->customer = $customer;
        $this->lmsModel = $lmsModel;
        $this->_order = $order;
        $this->_resource = $resource;
        $this->authSession = $authSession;
        $this->addressFactory = $addressFactory;
        $this->resultPageFactory = $resultPageFactory;
    }

    public function execute()
    {
       
        $resultPage = $this->resultPageFactory->create();
      
        $resultRedirect = $this->resultRedirectFactory->create();
        
        if($this->getRequest()->getParam('order_id'))
    	{
            $orderId = $this->getRequest()->getParam('order_id');
            $order = $this->orderRepository->get($orderId);

           
            $aId = $this->getRequest()->getParam('aid');

            $orderAddressDelegate = $this->orderAddressDelegate->create()->getCollection()
            ->addFieldToFilter('order_id', $orderId);
        
            if($aId){
                $orderAddressDelegate->addFieldToFilter('entity_id', $aId);
            }

            $is_multidel = 0;
            $multidel_id = 0;
            $addressArr = $orderAddressDelegate->getData();

            $mdval=0;
    		$is_login_careated = 0; 
    		if (count ( $addressArr ) > 0) {
            foreach ( $addressArr as $add ) {
                
                if (! empty ( $add['customer_address_id'] )) {
                    $shipfirstname = $add ['firstname'];
                    $shiplastname = $add ['lastname'];
                    $shiperemail = trim($add['delegate_email']);
                }
                else 
                {
                    $shipfirstname = $order->getShippingAddress()->getFirstname ();
                    $shiplastname = $order->getShippingAddress()->getLastname ();
                    $shiperemail = trim($order->getShippingAddress()->getDelegateEmail());
                }
                
                   $shiperemail = str_replace("’","'",$shiperemail);
                    if(!empty($shiperemail))
                    {
                    $data = [];
                    $i = 0;
                    $prod = $this->_productRepository->getById($add['product_id']);
                    
                    if (! empty ( $prod->getData ('lms') ) || ! empty ( $prod->getData ('ep_link') )) {
                    
                        $data[$i]['id'] = $prod->getData('entity_id');
                        $data[$i]['sku'] = $prod->getData('sku');
                        $data[$i]['lms'] = $prod->getData('lms');
                        $data[$i]['ep_link'] = $prod->getData('ep_link');
                        $lmsreplace = str_replace ( "days", "", strtolower ( $prod->getData ( 'license_expiry' ) ) );
                        $data [$i] ['license_expiry'] = trim ( $lmsreplace ) . ' days';
                        //Check if the customer available for give lms access

                        $existcustomer = $this->customer
                        ->setWebsiteId(1)
                        ->loadByEmail($shiperemail); 
                    
                        $already_customer = $existcustomer->getId();
                        if(empty($already_customer))
                        {   
                            $sendPassToEmail = true;
                            $isNewCustomer = 1;
                            $websiteId = 1;
                            $group_id = 1;
                            $password = $this->randomPassword();
                            $customernew = $this->customer;
                            $customernew->setForceConfirmed(true);
                            $customernew->setWebsiteId($websiteId)
                            ->setGroupId($group_id)
                            ->setFirstname($shipfirstname)
                            ->setLastname($shiplastname)
                            ->setEmail($shiperemail)
                            ->setPassword($password);
                            
                            $customernew->save();
                            $new_customer = $customernew->getId();
                            $customernew->sendNewAccountEmail();
                           
                            // Send welcome email
                            
                            //save customer address
                         $this->saveCustomerAddress($add,$new_customer);
                      
                            // if ($customernew->getWebsiteId() || $sendPassToEmail) {
                            //     $storeId = $customernew->getSendemailStoreId();
                            //     if ($isNewCustomer) {
                            //         $customernew->sendNewAccountEmail('registered', '', $storeId);
                        
                            //     } elseif ((!$customernew->getConfirmation())) {
                            //         // Confirm not confirmed customer
                            //         $customernew->sendNewAccountEmail('confirmed', '', $storeId);
                            //     }
                            // }
                            //echo $new_customer;exit();
                            $returnval = 0;
                            if (!empty($prod->getData('lms'))){				
                                $returnval = $this->lmsModel->getLmsAccess($data, $orderId, $new_customer, $shipfirstname, $shiplastname, $shiperemail, 1, $add['entity_id']);
                            }
                            if (empty($returnval) && !empty($prod->getData('ep_link'))) {
                                $returnval = 1;

                                $connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
                                $where = ['entity_id = ?' =>  $add['entity_id']];
                                $connection->update('sales_flat_order_address_delegate', ['lms_delegate_id' => $new_customer], $where);

                            }
                            $mdval = $mdval+$returnval;
                            
                            $updateQuery = $this->_order->load($orderId);
                            $updateQuery->setLmsAccess(1)->save();
                            
                            $is_login_careated++;
                        }
                        else
                        {				
                            $updateQuery = $this->_order->load($orderId);
                            $updateQuery->setLmsAccess(1)->save();

                            $returnval = 0;
                            if (!empty($prod->getData('lms'))){								
                            $returnval = $this->lmsModel->getLmsAccess($data, $orderId, $already_customer, $shipfirstname, $shiplastname, $shiperemail, 1, $add['entity_id']);
                            }
                            if ( empty ( $returnval ) && ! empty ( $prod->getData ( 'ep_link' ) )) {
                                $returnval = 1;
                                
                                $connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
                                $where = ['entity_id = ?' =>  $add['entity_id']];
                                $connection->update('sales_flat_order_address_delegate', ['lms_delegate_id' => $already_customer], $where);

                            }
                            $mdval = $mdval+$returnval;						
                            
                        }						
                    
                    }
                }
            }

            if($mdval > 0 && $is_login_careated > 0)
				{
                    $lmsadminorder = $this->_order->load($orderId);
                    $this->messageManager->addSuccess($is_login_careated.'New customer(s) was successfully created and '.$mdval.' LMS access has been provided');
					$adminusername = $this->authSession->getUser()->getName();
					$lmscomments = "LMS access - ".date('Y-m-d H:i:s').". LMS Access processed by ".$adminusername;
					$lmsadminorder->addStatusHistoryComment($lmscomments);
					$lmsadminorder->save();
				}
				elseif($mdval > 0)
				{
                    $lmsadminorder = $this->_order->load($orderId);
                    $this->messageManager->addSuccess($mdval.' LMS access has been provided successfully to customer');
					$adminusername = $this->authSession->getUser()->getName();
					$lmscomments = "LMS access - ".date('Y-m-d H:i:s').". LMS Access processed by ".$adminusername;
					$lmsadminorder->addStatusHistoryComment($lmscomments);
					$lmsadminorder->save();
				}
				else{
                    $this->messageManager->addError('No LMS access has been provided to customer');
                    $updateQuery = $this->_order->load($orderId);
                    $updateQuery->setLmsAccess(1)->save();

				}	
				//EOF Multiple delgates LMS access	

        }
        else{			
        $customer = $this->customer->load($order->getCustomerId());
        $customer_email = $customer->getEmail();
        $shiperemail = trim($order->getShippingAddress()->getDelegateEmail());
        $shiperemail = str_replace("’","'",$shiperemail);
            if (! empty ( $shiperemail )) {
                if ($shiperemail != $customer_email) {
                    $shipfirstname = $order->getShippingAddress ()->getFirstname ();
                    $shiplastname = $order->getShippingAddress ()->getLastname ();
                    $existcustomer = $this->customer->setWebsiteId ( 1 )->loadByEmail ( $shiperemail );
                    $already_customer = $existcustomer->getId ();						
                    $data = array ();
                    $i = 0;
                    $items = $order->getAllItems();
                    foreach ( $items as $itemId => $item ) {
                     if ($item->getHasChildren()) {
                            continue;
                        }
                        $prod = $this->_productRepository->getById ( $item->getProductId () );
                        if (! empty ( $prod->getData ( 'lms' ) ) || ! empty ( $prod->getData ( 'ep_link' ) )) {
                            $data [$i] ['id'] = $item->getProductId ();
                            $data [$i] ['sku'] = $prod->getData ( 'sku' );
                            $data [$i] ['lms'] = $prod->getData ( 'lms' );
                            $data [$i] ['ep_link'] = $prod->getData ( 'ep_link' );
                            $lmsreplace = str_replace ( "days", "", strtolower ( $prod->getData ( 'license_expiry' ) ) );
                            $data [$i] ['license_expiry'] = trim ( $lmsreplace ) . ' days';
                            $i++;
                        }
                    }

                    if (empty ( $already_customer )) {
                        $sendPassToEmail = true;
                        $isNewCustomer = 1;
                        $websiteId = 1;
                        $group_id = 1;
                        $password = $this->randomPassword ();
                        $customernew = $this->customer;
                        $customernew->setForceConfirmed ( true );
                        $customernew->setWebsiteId ( $websiteId )->setGroupId ( $group_id )->setFirstname ( $shipfirstname )->setLastname ( $shiplastname )->setEmail ( $shiperemail )->setPassword ( $password );
                        
                        $customernew->save ();
                        $new_customer = $customernew->getId ();

                        $customernew->sendNewAccountEmail();

                        // Send welcome email
                        
                $add = array (
                'firstname'  => $order->getShippingAddress ()->getFirstname(),
                'lastname'   => $order->getShippingAddress ()->getLastname(),
                'street'     => implode("\n", $order->getShippingAddress ()->getStreet()),
                'city'       => $order->getShippingAddress ()->getCity(),
                'company'    => $order->getShippingAddress ()->getCompany(),
                'postcode'   => $order->getShippingAddress ()->getPostcode(),
                'country_id' => $order->getShippingAddress ()->getCountryId(),
                'telephone'  => $order->getShippingAddress ()->getTelephone(),
                'fax'        => $order->getShippingAddress ()->getFax(),
                'prefix'     => $order->getShippingAddress ()->getPrefix(),
                'delegate_email' => $order->getShippingAddress ()->getDelegateEmail(),

            );
                if($order->getShippingAddress ()->getRegion ()) $add['region']=$order->getShippingAddress()->getRegion();
                if($order->getShippingAddress ()->getRegionId ()) $add['region_id']=$order->getShippingAddress ()->getRegionId();
                      
                        //save customer address
                        $this->saveCustomerAddress($add,$new_customer);
                        
                        // if ($customernew->getWebsiteId () || $sendPassToEmail) {
                        //     $storeId = $customernew->getSendemailStoreId ();
                        //     if ($isNewCustomer) {
                        //         $customernew->sendNewAccountEmail ( 'registered', '', $storeId );
                        //     } elseif ((! $customernew->getConfirmation ())) {
                        //         // Confirm not confirmed customer
                        //         $customernew->sendNewAccountEmail ( 'confirmed', '', $storeId );
                        //     }
                        // }
                        
                        $returnval = $this->lmsModel->getLmsAccess ( $data, $orderId, $new_customer, $shipfirstname, $shiplastname, $shiperemail, $is_multidel, $multidel_id );
                        $mdval = $mdval + $returnval;
                        

                        $updateQuery = $this->_order->load($orderId);
                        $updateQuery->setLmsDelegateId($new_customer)
                        ->setLmsAccess(1)->save();

                        $is_login_careated ++;
                    } else {
                        $returnval = $this->lmsModel->getLmsAccess ( $data, $orderId, $already_customer, $shipfirstname, $shiplastname, $shiperemail, $is_multidel, $multidel_id );
                        $mdval = $mdval + $returnval;
                        if ($is_multidel == 1) {
                            $updateQuery = $this->_order->load($orderId);
                            $updateQuery->setLmsAccess(1)->save();

                        } else {
                        
                            $updateQuery = $this->_order->load($orderId);
                            $updateQuery->setLmsDelegateId($already_customer)
                            ->setLmsAccess(1)->save();
                        }
                    }
                } else {
                    $shipfirstname = $order->getShippingAddress ()->getFirstname ();
                    $shiplastname = $order->getShippingAddress ()->getLastname ();
                    $customer_email = $customer->getEmail ();
                    $new_customer = $order->getCustomerId ();
                    
                    $data = array ();
                    $i = 0;
                    $items = $order->getAllItems();
                    foreach ( $items as $itemId => $item ) {
                    if ($item->getHasChildren()) {
                            continue;
                        }
                        $prod = $this->_productRepository->getById( $item->getProductId () );
                        if (! empty ( $prod->getData ( 'lms' ) ) || ! empty ( $prod->getData ( 'ep_link' ) )) {
                            $prod = $this->_productRepository->getById( $item->getProductId () );
                            $data [$i] ['id'] = $item->getProductId ();
                            $data [$i] ['sku'] = $prod->getData ( 'sku' );
                            $data [$i] ['lms'] = $prod->getData ( 'lms' );
                            $data [$i] ['ep_link'] = $prod->getData ( 'ep_link' );
                            $lmsreplace = str_replace ( "days", "", strtolower ( $prod->getData ( 'license_expiry' ) ) );
                            $data [$i] ['license_expiry'] = trim ( $lmsreplace ) . ' days';
                            $i++;
                        }
                    }
                    
                    $returnval = $this->lmsModel->getLmsAccess ( $data, $orderId, $new_customer, $shipfirstname, $shiplastname, $customer_email, 0, 0 );
                    $mdval = $mdval + $returnval;
                    
                    $updateQuery = $this->_order->load($orderId);
                $updateQuery->setLmsDelegateId($order->getCustomerId())
                ->setLmsAccess(1)->save();
                }
            } else {
                $first_name = $order->getBillingAddress ()->getFirstname ();
                $last_name = $order->getBillingAddress ()->getLastname ();
                $customer_email = $customer->getEmail ();
                $new_customer = $order->getCustomerId ();					
                $data = array ();
                $i = 0;					
                $items = $order->getAllItems();
                foreach ( $items as $itemId => $item ) {
                	if ($item->getHasChildren()) {
                            continue;
                        }
                        $prod = $this->_productRepository->getById( $item->getProductId () );
                        if (! empty ( $prod->getData ( 'lms' ) ) || ! empty ( $prod->getData ( 'ep_link' ) )) {
                            
                            $data [$i] ['id'] = $item->getProductId ();
                            $data [$i] ['sku'] = $prod->getData ( 'sku' );
                            $data [$i] ['lms'] = $prod->getData ( 'lms' );
                            $data [$i] ['ep_link'] = $prod->getData ( 'ep_link' );
                            $lmsreplace = str_replace ( "days", "", strtolower ( $prod->getData ( 'license_expiry' ) ) );
                            $data [$i] ['license_expiry'] = trim ( $lmsreplace ) . ' days';
                            $i++;
                        }
                }					
                $returnval = $this->lmsModel->getLmsAccess ( $data, $orderId, $new_customer, $first_name, $last_name, $customer_email, $is_multidel, $multidel_id );
                $mdval = $mdval + $returnval;					
                $updateQuery = $this->_order->load($orderId);
                $updateQuery->setLmsDelegateId($order->getCustomerId())
                ->setLmsAccess(1)->save();

            }
        
        if($mdval > 0 && $is_login_careated > 0)
            { 
                $lmsadminorder = $this->_order->load($orderId);
                $this->messageManager->addSuccess($is_login_careated.'New customer(s) was successfully created and '.$mdval.' LMS access has been provided');
                $adminusername = $this->authSession->getUser()->getName();
                $lmscomments = "LMS access - ".date('Y-m-d H:i:s').". LMS Access processed by ".$adminusername;
                $lmsadminorder->addStatusHistoryComment($lmscomments);
                $lmsadminorder->save();
            }
            elseif($mdval > 0)
            { 
                $lmsadminorder = $this->_order->load($orderId);
                $this->messageManager->addSuccess($mdval.' LMS access has been provided successfully to customer');
                $adminusername = $this->authSession->getUser()->getName();
                $lmscomments = "LMS access - ".date('Y-m-d H:i:s').". LMS Access processed by ".$adminusername;
                $lmsadminorder->addStatusHistoryComment($lmscomments);
                $lmsadminorder->save();
            }
            else{
                $this->messageManager->addError('No LMS access has been provided to customer');
                $lmsadminorder = $this->_order->load($orderId);
                $lmsadminorder->setLmsAccess(1)->save();

            } 		
        }
            
        }
        else
    	{
            $this->messageManager->addError('Unable to process now');
    	} 	

        return $resultRedirect->setPath('sales/order/view', ['order_id' => $this->getRequest()->getParam('order_id')]);
    }

    public function randomPassword() {
    	$alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
    	$pass = array(); //remember to declare $pass as an array
    	$alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    	for ($i = 0; $i < 10; $i++) {
    		$n = rand(0, $alphaLength);
    		$pass[] = $alphabet[$n];
    	}
    	return implode($pass); //turn the array into a string
    }

    public function saveCustomerAddress($address,$customerId)
	{
		
    $AddressNew = array (
        'firstname'  => $address['firstname'],
        'lastname'   => $address['lastname'],
        'street'     => explode("\n", $address['street']),
        'city'       => $address['city'],
        'company'    => $address['company'],
        'postcode'   => $address['postcode'],
        'country_id' => $address['country_id'],
        'telephone'  => $address['telephone'],
        'fax'        => $address['fax'],
        'prefix'        => $address['prefix'],
        'delegate_email' => $address['delegate_email']

    );
	if(isset($address['region'])) $AddressNew['region']=$address['region'];
	if(isset($address['region_id'])) $AddressNew['region_id']=$address['region_id'];
	
    $customerAddress   = $this->addressFactory->create();
    $customerAddress->setData($AddressNew)
        ->setCustomerId($customerId) 
        ->setIsDefaultBilling('1')
        ->setIsDefaultShipping('1') 
        ->setSaveInAddressBook('1');
    $customerAddress->save();
	
    }
    
}
