<?php
/**
 * mc-magento2 Magento Component
 *
 * @category Ebizmarts
 * @package mc-magento2
 * @author Ebizmarts Team <info@ebizmarts.com>
 * @copyright Ebizmarts (http://ebizmarts.com)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 * @date: 9/30/16 2:46 PM
 * @file: Cmspage.php
 */

namespace Expedux\Lms\Model;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DataObject;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;


class LmsModel
{
    public function __construct(
				\Magento\Sales\Model\Order $order,
				ResourceConnection $resource,
				\Magento\Store\Model\StoreManagerInterface $storeManager,
				\Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
				\Magento\Catalog\Model\Product $product,
				ScopeConfigInterface $scopeConfig
    ) {
				$this->_order = $order;
				$this->_resource = $resource;
				$this->_storeManager=$storeManager;
				$this->_transportBuilder = $transportBuilder;
				$this->_product = $product;
				$this->scopeConfig = $scopeConfig;
    }
    public function getLmsAccess($data, $orderId, $customer_id, $first_name, $last_name, $customer_email, $is_multidel, $multidel_id) {  

		$first_name = trim(str_replace(" ", "", trim($first_name)));
    	$last_name = trim(str_replace(" ", "", trim($last_name)));
    	
    	$first_name = preg_replace ('/[^\s_\-a-zA-Z0-9]/u', '', $first_name);
    	$first_name = preg_replace ('/^\s+|\s+$/u', '', $first_name);
    	$first_name = preg_replace ('/[-\s]+/u', '', $first_name);
    	
    	$last_name = preg_replace ('/[^\s_\-a-zA-Z0-9]/u', '', $last_name);
    	$last_name = preg_replace ('/^\s+|\s+$/u', '', $last_name);
    	$last_name = preg_replace ('/[-\s]+/u', '', $last_name);
    	
    	$customer_email = trim($customer_email);
    	
    	$counter = 0;
    	if(count($data)>0)
        {    	
        $lmsorder = $this->_order->load($orderId);
    	$incrementId = $lmsorder->getIncrementId();
		
		//for multi delegates
		if ($is_multidel == 1) {
		
    	$product_sku=$data[0]['sku'];
    	$product_id=$data[0]['id'];
    	$product_lms=$data[0]['lms'];
    	$license_expiry_chk = trim(str_replace("days","",$data[0]['license_expiry']));
    	$license_expiry = $license_expiry_chk. " days";
	    $product_ep_link=$data[0]['ep_link'];
			// $customer_id = 7317;
			// $first_name = 'Suresh';
			// $last_name = 'Gnana';
    	$user_id="mg_".$customer_id."_".$first_name.$last_name;    	
    	$reference_info = $incrementId.":".$product_sku;
    	$partnerSalt = "2pTNRsALT!magento";
    	$auth=md5($user_id.$partnerSalt);
    	$new_license_expiry=date('Y-m-d', strtotime("+".$license_expiry));
    	
			if ($product_lms != '')
			{
					
				$type_user='checkUserID';
				$url_checkUser="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&type=".$type_user;
				$url_checkUser = preg_replace('/\s+/', '', $url_checkUser);
				
				$usercurl_handle=curl_init();
				curl_setopt($usercurl_handle,CURLOPT_URL,$url_checkUser);
				curl_setopt($usercurl_handle,CURLOPT_CONNECTTIMEOUT,2);
				curl_setopt($usercurl_handle,CURLOPT_RETURNTRANSFER,1);
				$buffer_user = curl_exec($usercurl_handle);
					curl_close($usercurl_handle);
				if(!empty($buffer_user)){ 
				$type='addProduct';
				$url="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&userFName=".$first_name."&userLName=".$last_name."&emailID=".$customer_email."&product=".$product_lms."&licenseExpiry=".$new_license_expiry."&referenceInfo=".$reference_info."&type=".$type;
				$curl_handle=curl_init();
				curl_setopt($curl_handle,CURLOPT_URL,$url);
				curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
				curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
				$buffer = curl_exec($curl_handle);    
				curl_close($curl_handle);
				}
				else{ 
				$type='addUser';
				$url="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&userFName=".$first_name."&userLName=".$last_name."&emailID=".$customer_email."&product=".$product_lms."&licenseExpiry=".$new_license_expiry."&referenceInfo=".$reference_info."&type=".$type;
				$curl_handle=curl_init();
				curl_setopt($curl_handle,CURLOPT_URL,$url);
				curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
				curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
				$buffer = curl_exec($curl_handle);    
				curl_close($curl_handle); 
				}
				
				//Begin Log for LMS Access if failed 
				$lmpos = strpos($buffer, 'bestpracticelms.com');
				if ($lmpos === false) {		
					$this->lmsAccessFailEmail($product_id, $incrementId, $customer_id, $first_name, $last_name, $customer_email);
				}	
				//EOF Log for LMS Access
				if(stristr($buffer,"bestpracticelms.com"))
				{

					$connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
					$where = ['entity_id = ?' =>  $multidel_id];
					$connection->update('sales_flat_order_address_delegate', ['lms_delegate_id' => $customer_id,'comment' => trim($buffer), 'lms_access' => 1], $where);
					$lmsorder->addStatusHistoryComment ( $buffer );
					$lmsorder->save ();					
				}
				else
				{
						$error = "Error Processing LMS.";
						$lmsorder->addStatusHistoryComment ( $error );
						$lmsorder->save ();			
						$connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
						$where = ['entity_id = ?' =>  $multidel_id];
						$connection->update('sales_flat_order_address_delegate', ['lms_delegate_id' => $customer_id,'lms_access' => 1], $where);

						
				}

				$counter ++;
					
			}
		}
		else
		{
			foreach($data as $lmsdata)
			{		
				$product_sku=$lmsdata['sku'];
				$product_id=$lmsdata['id'];
				$product_lms=$lmsdata['lms'];
				$product_ep_link=$lmsdata['ep_link'];
				
				$license_expiry_chk = trim(str_replace("days","",$lmsdata['license_expiry']));
				$license_expiry = $license_expiry_chk. " days";
					// $customer_id = 7317;
					// $first_name = 'Suresh';
					// $last_name = 'Gnana';
				$user_id="mg_".$customer_id."_".$first_name.$last_name;    	
				$reference_info = $incrementId.":".$product_sku;
				$partnerSalt = "2pTNRsALT!magento";
				$auth=md5($user_id.$partnerSalt);
				$new_license_expiry=date('Y-m-d', strtotime("+".$license_expiry));
				
				if ($product_lms != '')
				{					
					$type_user='checkUserID';
					$url_checkUser="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&type=".$type_user;
					$url_checkUser = preg_replace('/\s+/', '', $url_checkUser);
					
					$usercurl_handle=curl_init();
					curl_setopt($usercurl_handle,CURLOPT_URL,$url_checkUser);
					curl_setopt($usercurl_handle,CURLOPT_CONNECTTIMEOUT,2);
					curl_setopt($usercurl_handle,CURLOPT_RETURNTRANSFER,1);
					$buffer_user = curl_exec($usercurl_handle);
					curl_close($usercurl_handle);
					if(!empty($buffer_user)){  
						$type='addProduct';
						$url="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&userFName=".$first_name."&userLName=".$last_name."&emailID=".$customer_email."&product=".$product_lms."&licenseExpiry=".$new_license_expiry."&referenceInfo=".$reference_info."&type=".$type;
						$curl_handle=curl_init();
						curl_setopt($curl_handle,CURLOPT_URL,$url);
						curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
						curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
						$buffer = curl_exec($curl_handle);    
						curl_close($curl_handle);
					}
					else{ 
						$type='addUser';
						$url="http://www.bestpracticelms.com/EventPrep/mg_webService.php?userID=".$user_id."&auth=".$auth."&userFName=".$first_name."&userLName=".$last_name."&emailID=".$customer_email."&product=".$product_lms."&licenseExpiry=".$new_license_expiry."&referenceInfo=".$reference_info."&type=".$type;
						$curl_handle=curl_init();
						curl_setopt($curl_handle,CURLOPT_URL,$url);
						curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
						curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
						$buffer = curl_exec($curl_handle);    
						curl_close($curl_handle); 
					}				

					//Begin Log for LMS Access if failed 
					$lmpos = strpos($buffer, 'bestpracticelms.com');
					/*echo "<pre>";
					print_r($buffer);
					echo "==<br>";
					print_r($lmpos);exit;*/
					if ($lmpos === false) { 			
						$this->lmsAccessFailEmail($product_id, $incrementId, $customer_id, $first_name, $last_name, $customer_email);
						
					}   		
					//EOF Log for LMS Access					
					if(stristr($buffer,"bestpracticelms.com"))
					{
						$connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
						$where = ['order_id = ?' =>  $orderId, 'product_id = ?' => $product_id ];
						$connection->update('sales_order_item', ['lms_delegate_id' => $customer_id, 'lms_comment'=> trim($buffer), 'lms_access' => 1], $where);
						$lmsorder->addStatusHistoryComment ( $buffer );
						$lmsorder->save ();
						
					}
					else
					{
						$error = "Error Processing LMS.";
						$lmsorder->addStatusHistoryComment ( $error );
						$lmsorder->save ();
						$connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
						$where = ['order_id = ?' =>  $orderId, 'product_id = ?' => $product_id ];
						$connection->update('sales_order_item', ['lms_delegate_id' => $customer_id, 'lms_access' => 1], $where);

					}					
					$counter ++;				
				}
			
				if ($product_ep_link != '')
				{				
					$connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
					$where = ['order_id = ?' =>  $orderId, 'product_id = ?' => $product_id ];
					$connection->update('sales_order_item', ['lms_delegate_id' => $customer_id, 'lms_access' => 1], $where);
					$counter ++;				
				}			
			}//EOF Foreach
		}
		
		
    }
    return $counter;
  }

  public function lmsAccessFailEmail($product_id, $incrementId, $customer_id, $first_name, $last_name, $customer_email) {
	  
    $prodsku = $this->_product->load($product_id);
    
          $vars = array(
                  'firstname' => $first_name,
                  'lastname' => $last_name,
                  'email' => $customer_email,
                  'orderId' => $incrementId,
                  'productsku' => $prodsku->getData('sku'),
                  'productName' => $prodsku->getData('name')
          );
			
					$senderEmail = $this->scopeConfig->getValue('trans_email/ident_support/email',ScopeInterface::SCOPE_STORE);
					$senderName  = $this->scopeConfig->getValue('trans_email/ident_support/name',ScopeInterface::SCOPE_STORE);

          $bccEmail='logs@spoce.com';
          $bccName='spoce';
          

					$store = $this->_storeManager->getStore()->getId();

					$transport = $this->_transportBuilder->setTemplateIdentifier('lms_access_fail_email')
				->setTemplateOptions(['area' => 'frontend', 'store' => $store])
				->setTemplateVars(
					[
						'store' => $this->_storeManager->getStore(),
						'data' => new DataObject($vars)
					]
				)->setFrom('general');
				
					$this->_transportBuilder->addTo($bccEmail, $bccName);
				
				
				$this->_transportBuilder->getTransport()->sendMessage();

          //EOF Log for LMS Access
              } 

}
