<?php

namespace Expedux\Lms\Plugin\Block\Adminhtml\Order;

class View
{


    public function __construct(
        \Magento\Sales\Model\Order $order
    ) {
        $this->_order = $order;
    }

    public function beforeSetLayout(\Magento\Sales\Block\Adminhtml\Order\View $view)
    {
        $message ='Are you sure you want to do this?';
        $url = '/mymodule/controller/action/id/' . $view->getOrderId();
    
        $order = $this->_order->load($view->getOrderId());
    
        if(!$order->getLmsAccess()){
            $view->addButton(
                'order_myaction',
                [
                    'label' => __('LMS Access'),
                    'class' => 'myclass',
                    'onclick' => "confirmSetLocation('{$message}', '{$view->getUrl('lms/lms/lmsaccess',['order_id' => $view->getOrderId()])}')"
                ]
            );
        }
        
        if($order->getGrandTotal() == 0){
            $view->removeButton('order_invoice');
        }
    
    
    
    }
}