<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Expedux\OrdersJoinsEmail\Block\Adminhtml\Order;

/**
 * Order history block
 *
 * @api
 * @since 100.0.2
 */
class History extends \Magento\Sales\Block\Adminhtml\Order\View\History
{


 
   /**
     * Get stat uses
     *
     * @return array
     */
    public function getStatuses()
    {

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $orderConfig = $objectManager->create(\Magento\Sales\Model\Order\Config::class);
        $orderstausArr = ["processing", "pending", "complete", "holded", "canceled", "invoiced", "despatched", "duplicate", "unconfirmed","awaiting_invoice","closed"];

        return $filtered = array_filter(
            $orderConfig->getStatuses(),
            function ($key) use ($orderstausArr) {
                return in_array($key, $orderstausArr);
            },
            ARRAY_FILTER_USE_KEY
        );


    }


}
